/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.xpath10;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.xpath10.Expr;

public class FunctionCallExpr
extends Expr {
    final List<Expr> fParams = new ArrayList<Expr>();
    String fName;
    String fPrefix;

    public FunctionCallExpr(String pfx, String name) {
        super(null);
        this.fName = name;
        this.fPrefix = pfx;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public String getFunctionName() {
        return this.fName;
    }

    public List<Expr> getParameters() {
        return this.fParams;
    }

    public void addParameter(Expr p) {
        this.fParams.add(p);
    }

    @Override
    protected String asText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fnName()).append(this.argsToString(false));
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{FunctionCall,").append(this.getFunctionName()).append(",").append(this.argsToString(true)).append("}");
        return sb.toString();
    }

    String fnName() {
        if ("".equals(this.fPrefix) || this.fPrefix == null) {
            return this.fName;
        }
        return String.valueOf(this.fPrefix) + ":" + this.fName;
    }

    String argsToString(boolean asString) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int count = 0;
        for (Expr n : this.fParams) {
            if (count > 0) {
                sb.append(", ");
            }
            if (asString) {
                sb.append(n);
            } else {
                sb.append(n.getText());
            }
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }
}

