/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.factories;

import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.Copy;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Policy;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.factories.UIObjectFactoryProvider;
import org.eclipse.bpel.ui.util.XSDUtils;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class BPELUIObjectFactory
extends AbstractUIObjectFactory {
    protected static final String OBJ16 = "obj16/";
    protected static final String OBJ20 = "obj20/";
    protected static final String GIF = ".gif";
    protected static final String PNG = ".png";
    public static final String FOR_EACH_COUNTER_VARIABLE_TYPE = "unsignedInt";
    public static final String FOR_EACH_COUNTER_VARIABLE_NAME = "Counter";
    public static EClass[] classArray = new EClass[]{BPELPackage.eINSTANCE.getOpaqueActivity(), BPELPackage.eINSTANCE.getVariable(), BPELPackage.eINSTANCE.getCorrelationSet(), BPELPackage.eINSTANCE.getPartnerLink(), BPELPackage.eINSTANCE.getSequence(), BPELPackage.eINSTANCE.getFlow(), BPELPackage.eINSTANCE.getPick(), BPELPackage.eINSTANCE.getScope(), BPELPackage.eINSTANCE.getIf(), BPELPackage.eINSTANCE.getExit(), BPELPackage.eINSTANCE.getThrow(), BPELPackage.eINSTANCE.getRethrow(), BPELPackage.eINSTANCE.getCompensate(), BPELPackage.eINSTANCE.getCompensateScope(), BPELPackage.eINSTANCE.getWait(), BPELPackage.eINSTANCE.getWhile(), BPELPackage.eINSTANCE.getForEach(), BPELPackage.eINSTANCE.getRepeatUntil(), BPELPackage.eINSTANCE.getLink(), BPELPackage.eINSTANCE.getElseIf(), BPELPackage.eINSTANCE.getElse(), BPELPackage.eINSTANCE.getOnMessage(), BPELPackage.eINSTANCE.getOnAlarm(), BPELPackage.eINSTANCE.getFaultHandler(), BPELPackage.eINSTANCE.getCatch(), BPELPackage.eINSTANCE.getCatchAll(), BPELPackage.eINSTANCE.getCompensationHandler(), BPELPackage.eINSTANCE.getTerminationHandler(), BPELPackage.eINSTANCE.getEventHandler(), BPELPackage.eINSTANCE.getOnEvent(), BPELPackage.eINSTANCE.getMessageExchange(), BPELPackage.eINSTANCE.getValidate(), BPELPackage.eINSTANCE.getExtensionActivity()};
    protected EClass modelType;

    public BPELUIObjectFactory(EClass aModelType) {
        this.modelType = aModelType;
        if (this.modelType.getEPackage() != BPELPackage.eINSTANCE && Policy.DEBUG) {
            System.out.println("WARNING: constructing BPELUIObjectFactory(" + this.modelType.getName() + ") with non-BPELPackage EClass");
        }
    }

    @Override
    public EClass getModelType() {
        return this.modelType;
    }

    protected static String baseImageName(EClass modelObject) {
        if (modelObject == BPELPackage.eINSTANCE.getVariable()) {
            return "variable";
        }
        if (modelObject == BPELPackage.eINSTANCE.getPartnerLink()) {
            return "partner";
        }
        return modelObject.getName().toLowerCase();
    }

    @Override
    public ImageDescriptor getSmallImageDescriptor() {
        return BPELUIObjectFactory.getSmallImageDescriptor(this.getModelType());
    }

    @Override
    public ImageDescriptor getLargeImageDescriptor() {
        return BPELUIObjectFactory.getLargeImageDescriptor(this.getModelType());
    }

    public static ImageDescriptor getSmallImageDescriptor(EClass modelObject) {
        return BPELUIPlugin.INSTANCE.getImageDescriptor(OBJ16 + BPELUIObjectFactory.baseImageName(modelObject) + GIF);
    }

    public static ImageDescriptor getLargeImageDescriptor(EClass modelObject) {
        return BPELUIPlugin.INSTANCE.getImageDescriptor(OBJ20 + BPELUIObjectFactory.baseImageName(modelObject) + PNG);
    }

    @Override
    public Image getSmallImage() {
        return BPELUIPlugin.INSTANCE.getImage(OBJ16 + BPELUIObjectFactory.baseImageName(this.getModelType()) + GIF);
    }

    @Override
    public Image getLargeImage() {
        return BPELUIPlugin.INSTANCE.getImage(OBJ20 + BPELUIObjectFactory.baseImageName(this.getModelType()) + PNG);
    }

    @Override
    public String getTypeLabel() {
        return this.getModelType().getName();
    }

    public EObject createInstance() {
        Object result = super.createInstance();
        if (result instanceof Scope) {
            Scope scope = (Scope)result;
            scope.setVariables(BPELFactory.eINSTANCE.createVariables());
            scope.setPartnerLinks(BPELFactory.eINSTANCE.createPartnerLinks());
            scope.setCorrelationSets(BPELFactory.eINSTANCE.createCorrelationSets());
            scope.setMessageExchanges(BPELFactory.eINSTANCE.createMessageExchanges());
        } else if (result instanceof Pick) {
            Pick pick = (Pick)result;
            OnMessage onMessage = (OnMessage)UIObjectFactoryProvider.getInstance().getFactoryFor(BPELPackage.eINSTANCE.getOnMessage()).createInstance();
            pick.getMessages().add((Object)onMessage);
        } else if (result instanceof Assign) {
            Assign assign = (Assign)result;
            Copy copy = BPELFactory.eINSTANCE.createCopy();
            assign.getCopy().add((Object)copy);
        } else if (result instanceof ForEach) {
            ForEach forEach = (ForEach)result;
            Variable variable = BPELFactory.eINSTANCE.createVariable();
            XSDSimpleTypeDefinition varType = XSDUtils.getPrimitive(FOR_EACH_COUNTER_VARIABLE_TYPE);
            variable.setType((XSDTypeDefinition)varType);
            variable.setName(FOR_EACH_COUNTER_VARIABLE_NAME);
            forEach.setCounterName(variable);
            Scope scope = BPELFactory.eINSTANCE.createScope();
            forEach.setActivity((Activity)scope);
        } else if (result instanceof CatchAll || result instanceof Catch || result instanceof CompensationHandler) {
            Sequence sequence = BPELFactory.eINSTANCE.createSequence();
            sequence.getActivities().add((Object)BPELFactory.eINSTANCE.createCompensate());
            if (result instanceof CatchAll || result instanceof Catch) {
                sequence.getActivities().add((Object)BPELFactory.eINSTANCE.createRethrow());
            }
            if (result instanceof Catch) {
                Catch _catch = (Catch)result;
                _catch.setActivity((Activity)sequence);
            } else if (result instanceof CatchAll) {
                CatchAll _catchAll = (CatchAll)result;
                _catchAll.setActivity((Activity)sequence);
            } else if (result instanceof CompensationHandler) {
                CompensationHandler _compensationHandler = (CompensationHandler)result;
                _compensationHandler.setActivity((Activity)sequence);
            }
        } else if (result instanceof TerminationHandler) {
            TerminationHandler terminationHandler = (TerminationHandler)result;
            terminationHandler.setActivity((Activity)BPELFactory.eINSTANCE.createCompensate());
        } else if (result instanceof OnEvent) {
            OnEvent onEvent = (OnEvent)result;
            onEvent.setActivity((Activity)BPELFactory.eINSTANCE.createScope());
        } else if (result instanceof OnAlarm) {
            OnAlarm onAlarm = (OnAlarm)result;
            onAlarm.setActivity((Activity)BPELFactory.eINSTANCE.createScope());
        }
        return result;
    }
}

