/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search.internal;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.core.search.SearchParticipant;

public class SearchParticipantDescriptor {
    private IConfigurationElement fElement;
    private SearchParticipant participant;

    public SearchParticipantDescriptor(IConfigurationElement element) {
        this.fElement = element;
    }

    public SearchParticipant getSearchParticipant() {
        if (this.participant == null) {
            try {
                this.participant = (SearchParticipant)this.fElement.createExecutableExtension("class");
            }
            catch (Exception exception) {}
        }
        return this.participant;
    }

    public boolean matches(IEvaluationContext context) throws CoreException {
        IConfigurationElement[] elements = this.fElement.getChildren("enablement");
        if (elements.length == 0) {
            return false;
        }
        Assert.isTrue((elements.length == 1 ? 1 : 0) != 0);
        Expression exp = ExpressionConverter.getDefault().perform(elements[0]);
        return this.convert(exp.evaluate(context));
    }

    private boolean convert(EvaluationResult eval) {
        return eval != EvaluationResult.FALSE;
    }

    public String[] getSupportedContentTypes() {
        return new String[0];
    }

    public void addSupportedContentTypeId(String contentTypeId) {
    }

    public String getElementId() {
        return this.fElement.getAttribute("id");
    }
}

