/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.views;

import org.eclipse.ptp.internal.debug.ui.views.AbstractCTableCellEditor;
import org.eclipse.ptp.internal.debug.ui.views.CTable;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class CTableTextCellEditor
extends AbstractCTableCellEditor {
    private Text m_Text;
    private boolean editable;

    public CTableTextCellEditor(boolean editable) {
        this.editable = editable;
    }

    public void open(CTable table, int col, int row, Rectangle rect) {
        super.open(table, col, row, rect);
        this.m_Text.setText(this.m_Model.getContentAt(this.m_Col, this.m_Row).toString());
        this.m_Text.selectAll();
        this.m_Text.setVisible(true);
        this.m_Text.setFocus();
    }

    public void close(boolean save) {
        if (save) {
            this.m_Model.setContentAt(this.m_Col, this.m_Row, this.m_Text.getText());
        }
        super.close(save);
        this.m_Text = null;
    }

    protected Control createControl() {
        this.m_Text = new Text((Composite)this.m_Table, 0);
        this.m_Text.setEditable(this.editable);
        this.m_Text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                try {
                    CTableTextCellEditor.this.onKeyPressed(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.m_Text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent arg0) {
                CTableTextCellEditor.this.onTraverse(arg0);
            }
        });
        return this.m_Text;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(new Rectangle(rect.x, rect.y + (rect.height - 15) / 2 + 1, rect.width, 15));
    }
}

