/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.photran.internal.core.preprocessor.c.DateMacro;
import org.eclipse.photran.internal.core.preprocessor.c.DynamicMacro;
import org.eclipse.photran.internal.core.preprocessor.c.EndOfFileException;
import org.eclipse.photran.internal.core.preprocessor.c.ExpressionEvaluator;
import org.eclipse.photran.internal.core.preprocessor.c.FileMacro;
import org.eclipse.photran.internal.core.preprocessor.c.FunctionStyleMacro;
import org.eclipse.photran.internal.core.preprocessor.c.IIndexBasedCodeReaderFactory;
import org.eclipse.photran.internal.core.preprocessor.c.ILexerLog;
import org.eclipse.photran.internal.core.preprocessor.c.ILocationCtx;
import org.eclipse.photran.internal.core.preprocessor.c.IToken;
import org.eclipse.photran.internal.core.preprocessor.c.ImageLocationInfo;
import org.eclipse.photran.internal.core.preprocessor.c.IncludeFileContent;
import org.eclipse.photran.internal.core.preprocessor.c.Lexer;
import org.eclipse.photran.internal.core.preprocessor.c.LineMacro;
import org.eclipse.photran.internal.core.preprocessor.c.LocationMap;
import org.eclipse.photran.internal.core.preprocessor.c.MacroDefinitionParser;
import org.eclipse.photran.internal.core.preprocessor.c.MacroExpander;
import org.eclipse.photran.internal.core.preprocessor.c.ObjectStyleMacro;
import org.eclipse.photran.internal.core.preprocessor.c.OffsetLimitReachedException;
import org.eclipse.photran.internal.core.preprocessor.c.PreprocessorMacro;
import org.eclipse.photran.internal.core.preprocessor.c.ScannerContext;
import org.eclipse.photran.internal.core.preprocessor.c.ScannerUtility;
import org.eclipse.photran.internal.core.preprocessor.c.TimeMacro;
import org.eclipse.photran.internal.core.preprocessor.c.Token;
import org.eclipse.photran.internal.core.preprocessor.c.TokenForInclude;
import org.eclipse.photran.internal.core.preprocessor.c.TokenList;
import org.eclipse.photran.internal.core.preprocessor.c.TokenWithImage;

public class CPreprocessor
implements ILexerLog,
IAdaptable {
    public static final String PROP_VALUE = "CPreprocessor";
    public static final int tDEFINED = -200;
    public static final int tEXPANDED_IDENTIFIER = -199;
    public static final int tSCOPE_MARKER = -198;
    public static final int tSPACE = -197;
    public static final int tNOSPACE = -196;
    public static final int tMACRO_PARAMETER = -195;
    public static final int tBLANK = -194;
    public static final int tINCLUDED_FILE_START = -193;
    public static final int tINCLUDED_FILE_END = -192;
    public static final int tPARENT_INCLUDE = -191;
    public static final int tPARENT_INCLUDE_NEXT = -190;
    public static final int tPARENT_IMPORT = -189;
    public static final int tPARENT_BASIC_MACRO = -188;
    public static final int tPARENT_FUNCTION_MACRO = -187;
    public static final int tPARENT_DIRECTIVE = -186;
    private static final int ORIGIN_PREPROCESSOR_DIRECTIVE = 2;
    private static final int ORIGIN_INACTIVE_CODE = 3;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final char[] ONE = "1".toCharArray();
    private static final String EMPTY_STRING = "";
    private static final ObjectStyleMacro __CDT_PARSER__ = new ObjectStyleMacro("__CDT_PARSER__".toCharArray(), ONE);
    private static final ObjectStyleMacro __cplusplus = new ObjectStyleMacro("__cplusplus".toCharArray(), ONE);
    private static final ObjectStyleMacro __STDC__ = new ObjectStyleMacro("__STDC__".toCharArray(), ONE);
    private static final ObjectStyleMacro __STDC_HOSTED__ = new ObjectStyleMacro("__STDC_HOSTED_".toCharArray(), ONE);
    private static final ObjectStyleMacro __STDC_VERSION__ = new ObjectStyleMacro("__STDC_VERSION_".toCharArray(), "199901L".toCharArray());
    private static final DynamicMacro __FILE__ = new FileMacro("__FILE__".toCharArray());
    private static final DynamicMacro __DATE__ = new DateMacro("__DATE__".toCharArray());
    private static final DynamicMacro __TIME__ = new TimeMacro("__TIME__".toCharArray());
    private static final DynamicMacro __LINE__ = new LineMacro("__LINE__".toCharArray());
    private final IIncludeFileTester<IncludeFileContent> createCodeReaderTester = new IIncludeFileTester<IncludeFileContent>(){

        @Override
        public IncludeFileContent checkFile(String path, String fileName) {
            String finalPath = ScannerUtility.createReconciledPath(path, fileName);
            return CPreprocessor.this.fCodeReaderFactory.getContentForInclusion(finalPath);
        }
    };
    private final IIncludeFileTester<String> createPathTester = new IIncludeFileTester<String>(){

        @Override
        public String checkFile(String path, String fileName) {
            String finalPath = ScannerUtility.createReconciledPath(path, fileName);
            if (CPreprocessor.this.fCodeReaderFactory.getInclusionExists(finalPath)) {
                return finalPath;
            }
            return null;
        }
    };
    private final IParserLogService fLog;
    private final IIndexBasedCodeReaderFactory fCodeReaderFactory;
    private final ExpressionEvaluator fExpressionEvaluator;
    private final MacroDefinitionParser fMacroDefinitionParser;
    private final MacroExpander fMacroExpander;
    private final Lexer.LexerOptions fLexOptions = new Lexer.LexerOptions();
    private final char[] fAdditionalNumericLiteralSuffixes;
    private final CharArrayIntMap fKeywords;
    private final CharArrayIntMap fPPKeywords;
    private final String[] fIncludePaths;
    private final String[] fQuoteIncludePaths;
    private String[][] fPreIncludedFiles = null;
    private int fContentAssistLimit = -1;
    private boolean fHandledCompletion = false;
    private final CharArrayMap<PreprocessorMacro> fMacroDictionary = new CharArrayMap(512);
    private final LocationMap fLocationMap = new LocationMap();
    private final HashSet<String> fAllIncludedFiles = new HashSet();
    private final Lexer fRootLexer;
    private final ScannerContext fRootContext;
    private ScannerContext fCurrentContext;
    private boolean isCancelled = false;
    private boolean fIsFirstFetchToken = true;
    private Token fPrefetchedTokens;
    private Token fLastToken;
    private TokenList fPreobtainedTokens = new TokenList();

    public CPreprocessor(CodeReader reader, IScannerInfo info, ParserLanguage language, IParserLogService log, IScannerExtensionConfiguration configuration, ICodeReaderFactory readerFactory) {
        this(reader, info, language, log, configuration, readerFactory, false, false);
    }

    public CPreprocessor(CodeReader reader, IScannerInfo info, ParserLanguage language, IParserLogService log, IScannerExtensionConfiguration configuration, ICodeReaderFactory readerFactory, boolean supportAtSignInIndent) {
        this(reader, info, language, log, configuration, readerFactory, supportAtSignInIndent, false);
    }

    public CPreprocessor(CodeReader reader, IScannerInfo info, ParserLanguage language, IParserLogService log, IScannerExtensionConfiguration configuration, ICodeReaderFactory readerFactory, boolean supportAtSignInIdent, boolean supportSlashPercentComments) {
        this.fLog = log;
        this.fAdditionalNumericLiteralSuffixes = this.nonNull(configuration.supportAdditionalNumericLiteralSuffixes());
        this.fLexOptions.fSupportDollarInIdentifiers = configuration.support$InIdentifiers();
        this.fLexOptions.fSupportAtSignInIdentifiers = supportAtSignInIdent;
        this.fLexOptions.fSupportSlashPercentComments = supportSlashPercentComments;
        this.fLexOptions.fSupportMinAndMax = configuration.supportMinAndMaxOperators();
        this.fKeywords = new CharArrayIntMap(40, -1);
        this.fPPKeywords = new CharArrayIntMap(40, -1);
        this.configureKeywords(language, configuration);
        this.fIncludePaths = info.getIncludePaths();
        this.fQuoteIncludePaths = this.getQuoteIncludePath(info);
        this.fExpressionEvaluator = new ExpressionEvaluator();
        this.fMacroDefinitionParser = new MacroDefinitionParser();
        this.fMacroExpander = new MacroExpander(this, this.fMacroDictionary, this.fLocationMap, this.fLexOptions);
        this.fCodeReaderFactory = this.wrapReaderFactory(readerFactory);
        this.setupMacroDictionary(configuration, info, language);
        String filePath = new String(reader.filename);
        this.fAllIncludedFiles.add(filePath);
        ILocationCtx ctx = this.fLocationMap.pushTranslationUnit(filePath, reader.buffer);
        this.fRootLexer = new Lexer(reader.buffer, this.fLexOptions, this, this);
        this.fRootContext = this.fCurrentContext = new ScannerContext(ctx, null, this.fRootLexer);
        if (info instanceof IExtendedScannerInfo) {
            IExtendedScannerInfo einfo = (IExtendedScannerInfo)info;
            this.fPreIncludedFiles = new String[][]{einfo.getMacroFiles(), einfo.getIncludeFiles()};
        }
    }

    private IIndexBasedCodeReaderFactory wrapReaderFactory(final ICodeReaderFactory readerFactory) {
        if (readerFactory instanceof IIndexBasedCodeReaderFactory) {
            return (IIndexBasedCodeReaderFactory)readerFactory;
        }
        return new IIndexBasedCodeReaderFactory(){

            public CodeReader createCodeReaderForTranslationUnit(String path) {
                return readerFactory.createCodeReaderForTranslationUnit(path);
            }

            public CodeReader createCodeReaderForInclusion(String path) {
                return readerFactory.createCodeReaderForInclusion(path);
            }

            @Override
            public IncludeFileContent getContentForInclusion(String path) {
                CodeReader reader = readerFactory.createCodeReaderForInclusion(path);
                if (reader != null) {
                    return new IncludeFileContent(reader);
                }
                return null;
            }

            @Override
            public boolean hasFileBeenIncludedInCurrentTranslationUnit(String path) {
                return CPreprocessor.this.fAllIncludedFiles.contains(path);
            }

            public ICodeReaderCache getCodeReaderCache() {
                return readerFactory.getCodeReaderCache();
            }

            public int getUniqueIdentifier() {
                return readerFactory.getUniqueIdentifier();
            }

            @Override
            public boolean getInclusionExists(String path) {
                return readerFactory.createCodeReaderForInclusion(path) != null;
            }

            @Override
            public IncludeFileContent getContentForContextToHeaderGap(String fileLocation) {
                return null;
            }
        };
    }

    public void setComputeImageLocations(boolean val) {
        this.fLexOptions.fCreateImageLocations = val;
    }

    public void setContentAssistMode(int offset) {
        this.fContentAssistLimit = offset;
        this.fRootLexer.setContentAssistMode(offset);
    }

    public void setScanComments(boolean val) {
    }

    private void configureKeywords(ParserLanguage language, IScannerExtensionConfiguration configuration) {
        Keywords.addKeywordsPreprocessor((CharArrayIntMap)this.fPPKeywords);
        if (language == ParserLanguage.C) {
            Keywords.addKeywordsC((CharArrayIntMap)this.fKeywords);
        } else {
            Keywords.addKeywordsCpp((CharArrayIntMap)this.fKeywords);
        }
        CharArrayIntMap additionalKeywords = configuration.getAdditionalKeywords();
        if (additionalKeywords != null) {
            this.fKeywords.putAll(additionalKeywords);
        }
        if ((additionalKeywords = configuration.getAdditionalPreprocessorKeywords()) != null) {
            this.fPPKeywords.putAll(additionalKeywords);
        }
    }

    protected String getCurrentFilename() {
        return this.fLocationMap.getCurrentFilePath();
    }

    private char[] nonNull(char[] array) {
        return array == null ? EMPTY_CHAR_ARRAY : array;
    }

    private String[] getQuoteIncludePath(IScannerInfo info) {
        IExtendedScannerInfo einfo;
        String[] qip;
        if (info instanceof IExtendedScannerInfo && (qip = (einfo = (IExtendedScannerInfo)info).getLocalIncludePath()) != null && qip.length > 0) {
            String[] result = new String[qip.length + this.fIncludePaths.length];
            System.arraycopy(qip, 0, result, 0, qip.length);
            System.arraycopy(this.fIncludePaths, 0, result, qip.length, this.fIncludePaths.length);
            return result;
        }
        return info.getIncludePaths();
    }

    private void setupMacroDictionary(IScannerExtensionConfiguration config, IScannerInfo info, ParserLanguage lang) {
        Map macroDict;
        this.fMacroDictionary.put(__CDT_PARSER__.getNameCharArray(), (Object)__CDT_PARSER__);
        this.fMacroDictionary.put(__STDC__.getNameCharArray(), (Object)__STDC__);
        this.fMacroDictionary.put(__FILE__.getNameCharArray(), (Object)__FILE__);
        this.fMacroDictionary.put(__DATE__.getNameCharArray(), (Object)__DATE__);
        this.fMacroDictionary.put(__TIME__.getNameCharArray(), (Object)__TIME__);
        this.fMacroDictionary.put(__LINE__.getNameCharArray(), (Object)__LINE__);
        if (lang == ParserLanguage.CPP) {
            this.fMacroDictionary.put(__cplusplus.getNameCharArray(), (Object)__cplusplus);
        } else {
            this.fMacroDictionary.put(__STDC_HOSTED__.getNameCharArray(), (Object)__STDC_HOSTED__);
            this.fMacroDictionary.put(__STDC_VERSION__.getNameCharArray(), (Object)__STDC_VERSION__);
        }
        IMacro[] toAdd = config.getAdditionalMacros();
        if (toAdd != null) {
            IMacro[] iMacroArray = toAdd;
            int n = toAdd.length;
            int n2 = 0;
            while (n2 < n) {
                IMacro macro = iMacroArray[n2];
                this.addMacroDefinition(macro.getSignature(), macro.getExpansion());
                ++n2;
            }
        }
        if ((macroDict = info.getDefinedSymbols()) != null) {
            for (Map.Entry entry : macroDict.entrySet()) {
                String key = (String)entry.getKey();
                String value = ((String)entry.getValue()).trim();
                this.addMacroDefinition(key.toCharArray(), value.toCharArray());
            }
        }
        Collection predefined = this.fMacroDictionary.values();
        for (PreprocessorMacro macro : predefined) {
            this.fLocationMap.registerPredefinedMacro(macro);
        }
    }

    private void beforeFirstFetchToken() {
        String location;
        IncludeFileContent content;
        if (this.fPreIncludedFiles != null) {
            this.handlePreIncludedFiles();
        }
        if ((content = this.fCodeReaderFactory.getContentForContextToHeaderGap(location = this.fLocationMap.getTranslationUnitPath())) != null && content.getKind() == IncludeFileContent.InclusionKind.FOUND_IN_INDEX) {
            this.processInclusionFromIndex(0, location, content);
        }
    }

    private void handlePreIncludedFiles() {
        String[] include;
        String[] imacro = this.fPreIncludedFiles[0];
        if (imacro != null && imacro.length > 0) {
            char[] buffer = this.createSyntheticFile(imacro);
            ILocationCtx ctx = this.fLocationMap.pushPreInclusion(buffer, 0, true);
            ScannerContext preCtx = this.fCurrentContext = new ScannerContext(ctx, this.fCurrentContext, new Lexer(buffer, this.fLexOptions, this, this));
            try {
                while (this.internalFetchToken(true, false, false, true, preCtx).getType() != 144) {
                }
                ILocationCtx locationCtx = this.fCurrentContext.getLocationCtx();
                this.fLocationMap.popContext(locationCtx);
                this.fCurrentContext = this.fCurrentContext.getParent();
                assert (this.fCurrentContext == this.fRootContext);
            }
            catch (OffsetLimitReachedException offsetLimitReachedException) {
                // empty catch block
            }
        }
        if ((include = this.fPreIncludedFiles[1]) != null && include.length > 0) {
            char[] buffer = this.createSyntheticFile(include);
            ILocationCtx ctx = this.fLocationMap.pushPreInclusion(buffer, 0, false);
            this.fCurrentContext = new ScannerContext(ctx, this.fCurrentContext, new Lexer(buffer, this.fLexOptions, this, this));
        }
        this.fPreIncludedFiles = null;
    }

    private char[] createSyntheticFile(String[] files) {
        int totalLength = 0;
        char[] instruction = "#include <".toCharArray();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            totalLength += instruction.length + 2 + file.length();
            ++n2;
        }
        char[] buffer = new char[totalLength];
        int pos = 0;
        String[] stringArray2 = files;
        int n3 = files.length;
        int n4 = 0;
        while (n4 < n3) {
            String file = stringArray2[n4];
            char[] fileName = file.toCharArray();
            System.arraycopy(instruction, 0, buffer, pos, instruction.length);
            System.arraycopy(fileName, 0, buffer, pos += instruction.length, fileName.length);
            pos += fileName.length;
            buffer[pos++] = 62;
            buffer[pos++] = 10;
            ++n4;
        }
        return buffer;
    }

    public PreprocessorMacro addMacroDefinition(char[] key, char[] value) {
        Lexer lex = new Lexer(key, this.fLexOptions, ILexerLog.NULL, null);
        try {
            PreprocessorMacro result = this.fMacroDefinitionParser.parseMacroDefinition(lex, ILexerLog.NULL, value);
            this.fLocationMap.registerPredefinedMacro(result);
            this.fMacroDictionary.put(result.getNameCharArray(), (Object)result);
            return result;
        }
        catch (Exception e) {
            this.fLog.traceLog("Invalid macro definition: '" + String.valueOf(key) + "'");
            return null;
        }
    }

    public Map<String, IMacroBinding> getMacroDefinitions() {
        HashMap<String, IMacroBinding> hashMap = new HashMap<String, IMacroBinding>(this.fMacroDictionary.size());
        for (char[] key : this.fMacroDictionary.keys()) {
            hashMap.put(String.valueOf(key), (IMacroBinding)this.fMacroDictionary.get(key));
        }
        return hashMap;
    }

    public boolean isOnTopContext() {
        return this.fCurrentContext == this.fRootContext;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    private Token fetchToken() throws OffsetLimitReachedException {
        Token t;
        if (this.fIsFirstFetchToken) {
            this.beforeFirstFetchToken();
            this.fIsFirstFetchToken = false;
        }
        if ((t = this.fPrefetchedTokens) != null) {
            this.fPrefetchedTokens = (Token)t.getNext();
            t.setNext(null);
            return t;
        }
        t = this.fPreobtainedTokens.removeFirst();
        if (t == null) {
            try {
                t = this.internalFetchToken(true, false, false, true, true, this.fRootContext);
            }
            catch (OffsetLimitReachedException e) {
                this.fHandledCompletion = true;
                throw e;
            }
        }
        int offset = this.fLocationMap.getSequenceNumberForOffset(t.getOffset());
        int endOffset = this.fLocationMap.getSequenceNumberForOffset(t.getEndOffset());
        t.setOffset(offset, endOffset);
        t.setNext(null);
        return t;
    }

    private void pushbackToken(Token t) {
        t.setNext(this.fPrefetchedTokens);
        this.fPrefetchedTokens = t;
    }

    public IToken nextTokenRaw() throws OffsetLimitReachedException {
        if (this.isCancelled) {
            throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
        Token t1 = this.fetchToken();
        switch (t1.getType()) {
            case 140: {
                this.fHandledCompletion = true;
                break;
            }
            case 144: {
                if (this.fContentAssistLimit < 0) break;
                int useType = this.fHandledCompletion ? 141 : 140;
                int sequenceNumber = this.fLocationMap.getSequenceNumberForOffset(this.fContentAssistLimit);
                t1 = new Token(useType, null, sequenceNumber, sequenceNumber);
                this.fHandledCompletion = true;
            }
        }
        if (this.fLastToken != null) {
            this.fLastToken.setNext(t1);
        }
        this.fLastToken = t1;
        return t1;
    }

    public IToken nextToken() throws EndOfFileException {
        if (this.isCancelled) {
            throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
        Token t1 = this.fetchToken();
        int tt1 = t1.getType();
        switch (tt1) {
            case 140: {
                this.fHandledCompletion = true;
                break;
            }
            case 144: {
                if (this.fContentAssistLimit < 0) {
                    throw new EndOfFileException();
                }
                int useType = this.fHandledCompletion ? 141 : 140;
                int sequenceNumber = this.fLocationMap.getSequenceNumberForOffset(this.fContentAssistLimit);
                t1 = new Token(useType, null, sequenceNumber, sequenceNumber);
                this.fHandledCompletion = true;
                break;
            }
            case 130: 
            case 131: {
                Token t2;
                boolean isWide = tt1 == 131;
                StringBuffer buf = null;
                int endOffset = 0;
                block8: while (true) {
                    t2 = this.fetchToken();
                    int tt2 = t2.getType();
                    switch (tt2) {
                        case 130: 
                        case 131: {
                            boolean bl = isWide = tt2 == 131;
                            if (buf == null) {
                                buf = new StringBuffer();
                                this.appendStringContent(buf, t1);
                            }
                            this.appendStringContent(buf, t2);
                            endOffset = t2.getEndOffset();
                            continue block8;
                        }
                    }
                    break;
                }
                this.pushbackToken(t2);
                if (buf == null) break;
                char[] image = new char[buf.length() + (isWide ? 3 : 2)];
                int off = -1;
                if (isWide) {
                    image[++off] = 76;
                }
                image[++off] = 34;
                buf.getChars(0, buf.length(), image, ++off);
                image[image.length - 1] = 34;
                t1 = new TokenWithImage(isWide ? 131 : 130, null, t1.getOffset(), endOffset, image);
            }
        }
        if (this.fLastToken != null) {
            this.fLastToken.setNext(t1);
        }
        this.fLastToken = t1;
        return t1;
    }

    private void appendStringContent(StringBuffer buf, Token t1) {
        char[] image = t1.getCharImage();
        int length = image.length;
        if (length > 1) {
            int diff;
            int start = image[0] == '\"' ? 1 : 2;
            int n = diff = image[length - 1] == '\"' ? length - start - 1 : length - start;
            if (diff > 0) {
                buf.append(image, start, diff);
            }
        }
    }

    Token internalFetchToken(boolean expandMacros, boolean isPPCondition, boolean stopAtNewline, boolean checkNumbers, ScannerContext uptoEndOfCtx) throws OffsetLimitReachedException {
        return this.internalFetchToken(expandMacros, isPPCondition, stopAtNewline, false, checkNumbers, uptoEndOfCtx);
    }

    Token internalFetchToken(boolean expandMacros, boolean isPPCondition, boolean stopAtNewline, boolean makeNewLineToken, boolean checkNumbers, ScannerContext uptoEndOfCtx) throws OffsetLimitReachedException {
        Token ppToken = this.fCurrentContext.currentLexerToken();
        block10: while (true) {
            switch (ppToken.getType()) {
                case -100: {
                    ppToken = this.fCurrentContext.nextPPToken();
                    continue block10;
                }
                case -99: {
                    if (makeNewLineToken) break block10;
                    if (stopAtNewline) {
                        return ppToken;
                    }
                    ppToken = this.fCurrentContext.nextPPToken();
                    continue block10;
                }
                case -96: {
                    this.handleProblem(0x1000001, ppToken.getCharImage(), ppToken.getOffset(), ppToken.getEndOffset());
                    break block10;
                }
                case 144: {
                    if (this.fCurrentContext == uptoEndOfCtx || uptoEndOfCtx == null) {
                        return ppToken;
                    }
                    Lexer lexer = this.fCurrentContext.getLexer();
                    boolean returnToken = lexer != null && lexer.getParentToken() != null;
                    ILocationCtx locationCtx = this.fCurrentContext.getLocationCtx();
                    this.fLocationMap.popContext(locationCtx);
                    this.fCurrentContext = this.fCurrentContext.getParent();
                    assert (this.fCurrentContext != null);
                    if (returnToken) {
                        ppToken.setType(-192);
                        return ppToken;
                    }
                    ppToken = this.fCurrentContext.currentLexerToken();
                    continue block10;
                }
                case 138: {
                    Lexer lexer = this.fCurrentContext.getLexer();
                    if (lexer == null || !lexer.currentTokenIsFirstOnLine()) break block10;
                    Token t = this.executeDirective(lexer, ppToken.getOffset());
                    if (t != null) {
                        return t;
                    }
                    ppToken = this.fCurrentContext.currentLexerToken();
                    continue block10;
                }
                case 1: {
                    Lexer lexer;
                    this.fCurrentContext.nextPPToken();
                    if (expandMacros) {
                        lexer = this.fCurrentContext.getLexer();
                        if (lexer != null && this.expandMacro(ppToken, lexer, stopAtNewline, isPPCondition)) {
                            ppToken = this.fCurrentContext.currentLexerToken();
                            continue block10;
                        }
                        char[] name = ppToken.getCharImage();
                        int tokenType = this.fKeywords.get(name);
                        if (tokenType != this.fKeywords.undefined) {
                            ppToken.setType(tokenType);
                        }
                    }
                    return ppToken;
                }
                case 2: {
                    if (!checkNumbers) break block10;
                    this.checkNumber(ppToken, false);
                    break block10;
                }
                case 129: {
                    if (!checkNumbers) break block10;
                    this.checkNumber(ppToken, true);
                }
            }
            break;
        }
        this.fCurrentContext.nextPPToken();
        return ppToken;
    }

    private void checkNumber(Token number, boolean isFloat) {
        char[] image = number.getCharImage();
        boolean hasExponent = false;
        boolean isHex = false;
        boolean isOctal = false;
        boolean hasDot = false;
        int pos = 0;
        if (image.length > 1 && image[0] == '0') {
            switch (image[++pos]) {
                case 'X': 
                case 'x': {
                    isHex = true;
                    ++pos;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    isOctal = true;
                    ++pos;
                    break;
                }
                case '8': 
                case '9': {
                    this.handleProblem(0x1000007, image, number.getOffset(), number.getEndOffset());
                    return;
                }
            }
        }
        block23: while (pos < image.length) {
            block5 : switch (image[pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    break;
                }
                case '8': 
                case '9': {
                    if (!isOctal) break;
                    this.handleProblem(0x1000007, image, number.getOffset(), number.getEndOffset());
                    return;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'f': {
                    if (!isHex || hasExponent) break block23;
                    break;
                }
                case '.': {
                    if (hasDot) {
                        this.handleProblem(0x1000004, image, number.getOffset(), number.getEndOffset());
                        return;
                    }
                    hasDot = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (isHex && !hasExponent) break;
                    if (!isFloat || isHex || hasExponent || pos + 1 > image.length) break block23;
                    switch (image[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            hasExponent = true;
                            ++pos;
                            break block5;
                        }
                    }
                    break block23;
                }
                case 'P': 
                case 'p': {
                    if (!isFloat || !isHex || hasExponent || pos + 1 < image.length) break block23;
                    switch (image[pos + 1]) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            hasExponent = true;
                            ++pos;
                            break block5;
                        }
                    }
                    break block23;
                }
                default: {
                    break block23;
                }
            }
            ++pos;
        }
        while (pos < image.length) {
            char c = image[pos];
            block19 : switch (c) {
                case 'L': 
                case 'U': 
                case 'l': 
                case 'u': {
                    break;
                }
                case 'F': 
                case 'f': {
                    if (isFloat) break;
                }
                default: {
                    int i = 0;
                    while (i < this.fAdditionalNumericLiteralSuffixes.length) {
                        if (this.fAdditionalNumericLiteralSuffixes[i] == c) break block19;
                        ++i;
                    }
                    if (isFloat) {
                        this.handleProblem(0x1000004, image, number.getOffset(), number.getEndOffset());
                    } else if (isHex) {
                        this.handleProblem(0x1000005, image, number.getOffset(), number.getEndOffset());
                    } else if (isOctal) {
                        this.handleProblem(0x1000007, image, number.getOffset(), number.getEndOffset());
                    } else {
                        this.handleProblem(0x1000008, image, number.getOffset(), number.getEndOffset());
                    }
                    return;
                }
            }
            ++pos;
        }
    }

    private IncludeFileContent findInclusion(String filename, boolean quoteInclude, boolean includeNext, File currentDir) {
        return this.findInclusion(filename, quoteInclude, includeNext, currentDir, this.createCodeReaderTester);
    }

    private <T> T findInclusion(String filename, boolean quoteInclude, boolean includeNext, File currentDirectory, IIncludeFileTester<T> tester) {
        String[] isp;
        String absolutePath;
        T reader = null;
        if (new File(filename).isAbsolute() || filename.startsWith("/")) {
            return tester.checkFile(EMPTY_STRING, filename);
        }
        if (currentDirectory != null && quoteInclude && !includeNext && (reader = (T)tester.checkFile(absolutePath = currentDirectory.getAbsolutePath(), filename)) != null) {
            return reader;
        }
        String[] stringArray = isp = quoteInclude ? this.fQuoteIncludePaths : this.fIncludePaths;
        if (isp != null) {
            int i = 0;
            if (includeNext && currentDirectory != null) {
                i = this.findIncludePos(isp, currentDirectory) + 1;
            }
            while (i < isp.length) {
                reader = tester.checkFile(isp[i], filename);
                if (reader != null) {
                    return reader;
                }
                ++i;
            }
        }
        return null;
    }

    private int findIncludePos(String[] paths, File currentDirectory) {
        while (currentDirectory != null) {
            int i = 0;
            while (i < paths.length) {
                File pathDir = new File(paths[i]);
                if (currentDirectory.equals(pathDir)) {
                    return i;
                }
                ++i;
            }
            currentDirectory = currentDirectory.getParentFile();
        }
        return -1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Scanner @ file:");
        buffer.append(this.fCurrentContext.toString());
        buffer.append(" line: ");
        buffer.append(this.fLocationMap.getCurrentLineNumber(this.fCurrentContext.currentLexerToken().getOffset()));
        return buffer.toString();
    }

    private void addMacroDefinition(IIndexMacro macro) {
        try {
            char[] expansionImage = macro.getExpansionImage();
            if (expansionImage == null) {
                this.fMacroDictionary.remove(macro.getNameCharArray());
            } else {
                PreprocessorMacro result = MacroDefinitionParser.parseMacroDefinition(macro.getNameCharArray(), macro.getParameterList(), expansionImage);
                IASTFileLocation loc = macro.getFileLocation();
                this.fLocationMap.registerMacroFromIndex(result, loc, -1);
                this.fMacroDictionary.put(result.getNameCharArray(), (Object)result);
            }
        }
        catch (Exception e) {
            this.fLog.traceLog("Invalid macro definition: '" + macro.getName() + "'");
        }
    }

    @Override
    public void handleComment(boolean isBlockComment, int offset, int endOffset) {
        this.fLocationMap.encounteredComment(offset, endOffset, isBlockComment);
    }

    @Override
    public void handleProblem(int id, char[] arg, int offset, int endOffset) {
        this.fLocationMap.encounterProblem(id, arg, offset, endOffset);
    }

    private Token executeDirective(Lexer lexer, int startOffset) throws OffsetLimitReachedException {
        Token poundToken = lexer.currentToken();
        Token ident = lexer.nextToken();
        switch (ident.getType()) {
            case 140: {
                lexer.nextToken();
                TokenWithImage completionToken = new TokenWithImage(ident.getType(), null, startOffset, ident.getEndOffset(), ("#" + ident.getImage()).toCharArray());
                throw new OffsetLimitReachedException(2, completionToken);
            }
            case -99: {
                return this.makeBlankDirToken(lexer, poundToken);
            }
            case 2: 
            case 144: {
                lexer.consumeLine(2);
                return this.makeBlankDirToken(lexer, poundToken);
            }
            case 1: {
                break;
            }
            default: {
                lexer.consumeLine(2);
                this.handleProblem(0x2000006, ident.getCharImage(), startOffset, lexer.getLastEndOffset());
                return this.makeBlankDirToken(lexer, poundToken);
            }
        }
        TokenForInclude includeToken = null;
        String includedFilePath = null;
        char[] name = ident.getCharImage();
        int type = this.fPPKeywords.get(name);
        switch (type) {
            case 12: {
                includeToken = new TokenForInclude(-189, null, 0, 0, null);
                includedFilePath = this.executeInclude(lexer, startOffset, false, true, includeToken);
                break;
            }
            case 6: {
                includeToken = new TokenForInclude(-191, null, 0, 0, null);
                includedFilePath = this.executeInclude(lexer, startOffset, false, true, includeToken);
                break;
            }
            case 11: {
                includeToken = new TokenForInclude(-190, null, 0, 0, null);
                includedFilePath = this.executeInclude(lexer, startOffset, true, true, includeToken);
                break;
            }
            case 7: {
                this.executeDefine(lexer, startOffset);
                break;
            }
            case 8: {
                this.executeUndefine(lexer, startOffset);
                break;
            }
            case 1: {
                this.executeIfdef(lexer, startOffset, true);
                break;
            }
            case 2: {
                this.executeIfdef(lexer, startOffset, false);
                break;
            }
            case 0: {
                this.executeIf(lexer, startOffset);
                break;
            }
            case 4: {
                lexer.consumeLine(2);
                if (this.fCurrentContext.changeBranch(ScannerContext.BRANCH_ELSE)) {
                    this.fLocationMap.encounterPoundElse(startOffset, ident.getEndOffset(), false);
                    this.skipOverConditionalCode(lexer, false);
                    break;
                }
                this.handleProblem(0x2000004, name, startOffset, ident.getEndOffset());
                break;
            }
            case 3: {
                int condOffset = lexer.nextToken().getOffset();
                int condEndOffset = lexer.consumeLine(2);
                int endOffset = lexer.currentToken().getEndOffset();
                if (this.fCurrentContext.changeBranch(ScannerContext.BRANCH_ELIF)) {
                    this.fLocationMap.encounterPoundElif(startOffset, condOffset, condEndOffset, endOffset, false, IASTName.EMPTY_NAME_ARRAY);
                    this.skipOverConditionalCode(lexer, false);
                    break;
                }
                this.handleProblem(0x2000004, name, startOffset, condEndOffset);
                break;
            }
            case 5: {
                lexer.consumeLine(2);
                if (this.fCurrentContext.changeBranch(ScannerContext.BRANCH_END)) {
                    this.fLocationMap.encounterPoundEndIf(startOffset, ident.getEndOffset());
                    break;
                }
                this.handleProblem(0x2000004, name, startOffset, ident.getEndOffset());
                break;
            }
            case 9: 
            case 13: {
                int condOffset = lexer.nextToken().getOffset();
                int condEndOffset = lexer.consumeLine(2);
                int endOffset = lexer.currentToken().getEndOffset();
                char[] warning = lexer.getInputChars(condOffset, condEndOffset);
                int id = type == 9 ? 0x2000001 : 0x200000E;
                this.handleProblem(id, warning, condOffset, condEndOffset);
                this.fLocationMap.encounterPoundError(startOffset, condOffset, condEndOffset, endOffset);
                break;
            }
            case 10: {
                int condOffset = lexer.nextToken().getOffset();
                int condEndOffset = lexer.consumeLine(2);
                int endOffset = lexer.currentToken().getEndOffset();
                this.fLocationMap.encounterPoundPragma(startOffset, condOffset, condEndOffset, endOffset);
                break;
            }
            case -2: {
                lexer.consumeLine(2);
                break;
            }
            default: {
                int condEndOffset = lexer.consumeLine(2);
                int endOffset = lexer.currentToken().getEndOffset();
                this.handleProblem(0x2000006, name, startOffset, condEndOffset);
            }
        }
        if (includedFilePath == null) {
            return this.makeBlankDirToken(lexer, poundToken);
        }
        includeToken.setParent(lexer.getParentToken());
        includeToken.setIncludeFile(includedFilePath);
        Token curToken = lexer.currentToken();
        int charStart = poundToken.getOrigOffset() - poundToken.getCharPrecedingWhiteSpace().length;
        int charEnd = curToken.getOrigOffset() - curToken.getCharPrecedingWhiteSpace().length;
        includeToken.setCharImage(lexer.getRawChars(charStart, charEnd));
        Token returnToken = new Token(-193, null, 0, 0);
        returnToken.setParent(includeToken);
        return returnToken;
    }

    private Token makeBlankDirToken(Lexer lexer, Token poundToken) {
        Token curToken = lexer.currentToken();
        int charStart = poundToken.getOrigOffset() - poundToken.getCharPrecedingWhiteSpace().length;
        int charEnd = curToken.getOrigOffset() - curToken.getCharPrecedingWhiteSpace().length;
        char[] rawChars = lexer.getRawChars(charStart, charEnd);
        TokenWithImage dirToken = new TokenWithImage(-186, null, 0, 0, rawChars);
        dirToken.setParent(lexer.getParentToken());
        Token blankToken = new Token(-194, null, charStart, charEnd);
        blankToken.setParent(dirToken);
        return blankToken;
    }

    private String executeInclude(Lexer lexer, int poundOffset, boolean include_next, boolean active, IToken parentToken) throws OffsetLimitReachedException {
        boolean expanded;
        boolean reported;
        String path;
        boolean userInclude;
        char[] headerName;
        int[] nameOffsets;
        int condEndOffset;
        block24: {
            block25: {
                File currentDir;
                IncludeFileContent fi;
                block23: {
                    lexer.setInsideIncludeDirective(true);
                    Token header = lexer.nextToken();
                    lexer.setInsideIncludeDirective(false);
                    condEndOffset = header.getEndOffset();
                    nameOffsets = new int[]{header.getOffset(), condEndOffset};
                    headerName = null;
                    userInclude = true;
                    block0 : switch (header.getType()) {
                        case -97: {
                            userInclude = false;
                            headerName = this.extractHeaderName(header.getCharImage(), '<', '>', nameOffsets);
                            condEndOffset = lexer.consumeLine(2);
                            break;
                        }
                        case -98: {
                            headerName = this.extractHeaderName(header.getCharImage(), '\"', '\"', nameOffsets);
                            condEndOffset = lexer.consumeLine(2);
                            break;
                        }
                        case 140: {
                            throw new OffsetLimitReachedException(2, header);
                        }
                        case 1: {
                            TokenList tl = new TokenList();
                            condEndOffset = nameOffsets[1] = this.getTokensWithinPPDirective(lexer, false, tl);
                            Token t = tl.first();
                            if (t == null) break;
                            switch (t.getType()) {
                                case 130: {
                                    headerName = this.extractHeaderName(t.getCharImage(), '\"', '\"', new int[2]);
                                    break;
                                }
                                case 42: {
                                    userInclude = false;
                                    boolean complete = false;
                                    StringBuffer buf = new StringBuffer();
                                    t = (Token)t.getNext();
                                    while (t != null) {
                                        if (t.getType() == 46) {
                                            complete = true;
                                            break;
                                        }
                                        buf.append(t.getImage());
                                        t = (Token)t.getNext();
                                    }
                                    if (!complete) break block0;
                                    headerName = new char[buf.length()];
                                    buf.getChars(0, buf.length(), headerName, 0);
                                }
                            }
                            break;
                        }
                        default: {
                            condEndOffset = lexer.consumeLine(2);
                        }
                    }
                    if (headerName == null || headerName.length == 0) {
                        if (active) {
                            this.handleProblem(0x2000006, lexer.getInputChars(poundOffset, condEndOffset), poundOffset, condEndOffset);
                        }
                        return null;
                    }
                    path = null;
                    reported = false;
                    expanded = false;
                    if (active) break block23;
                    File currentDir2 = userInclude || include_next ? new File(String.valueOf(this.getCurrentFilename())).getParentFile() : null;
                    String resolved = this.findInclusion(new String(headerName), userInclude, include_next, currentDir2, this.createPathTester);
                    if (resolved != null && this.fCodeReaderFactory.hasFileBeenIncludedInCurrentTranslationUnit(resolved)) {
                        path = resolved;
                    }
                    break block24;
                }
                IResource currFileRes = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getCurrentFilename());
                File tempFile = null;
                if (currFileRes != null) {
                    tempFile = currFileRes.getLocation().toFile().getParentFile();
                }
                if ((fi = this.findInclusion(new String(headerName), userInclude, include_next, currentDir = userInclude || include_next ? tempFile : null)) == null) break block25;
                path = fi.getFileLocation();
                switch (fi.getKind()) {
                    case FOUND_IN_INDEX: {
                        this.processInclusionFromIndex(poundOffset, path, fi);
                        break;
                    }
                    case USE_CODE_READER: {
                        CodeReader reader = fi.getCodeReader();
                        if (reader != null && !this.isCircularInclusion(path)) {
                            ScannerContext fctx;
                            reported = true;
                            this.fAllIncludedFiles.add(path);
                            ILocationCtx ctx = this.fLocationMap.pushInclusion(poundOffset, nameOffsets[0], nameOffsets[1], condEndOffset, reader.buffer, path, headerName, userInclude);
                            this.fCurrentContext = fctx = new ScannerContext(ctx, this.fCurrentContext, new Lexer(reader.buffer, this.fLexOptions, this, this, parentToken));
                            expanded = true;
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block24;
            }
            int len = headerName.length + 2;
            StringBuilder name = new StringBuilder(len);
            name.append(userInclude ? (char)'\"' : '<');
            name.append(headerName);
            name.append(userInclude ? (char)'\"' : '>');
            char[] nameChars = new char[len];
            name.getChars(0, len, nameChars, 0);
            this.handleProblem(0x2000002, nameChars, poundOffset, condEndOffset);
        }
        if (!reported) {
            this.fLocationMap.encounterPoundInclude(poundOffset, nameOffsets[0], nameOffsets[1], condEndOffset, headerName, path, userInclude, active);
        }
        if (expanded) {
            return path;
        }
        return null;
    }

    private void processInclusionFromIndex(int offset, String path, IncludeFileContent fi) {
        List<IIndexMacro> mdefs = fi.getMacroDefinitions();
        for (IIndexMacro macro : mdefs) {
            this.addMacroDefinition(macro);
        }
        this.fLocationMap.skippedFile(this.fLocationMap.getSequenceNumberForOffset(offset), fi);
    }

    private char[] extractHeaderName(char[] image, char startDelim, char endDelim, int[] offsets) {
        int start = 0;
        int length = image.length;
        if (length > 0 && image[length - 1] == endDelim) {
            offsets[1] = offsets[1] - 1;
            if (--length > 0 && image[0] == startDelim) {
                offsets[0] = offsets[0] + 1;
                ++start;
                --length;
            }
        }
        char[] headerName = new char[length];
        System.arraycopy(image, start, headerName, 0, length);
        return headerName;
    }

    private boolean isCircularInclusion(String filename) {
        ILocationCtx checkContext = this.fCurrentContext.getLocationCtx();
        while (checkContext != null) {
            if (filename.equals(checkContext.getFilePath())) {
                return true;
            }
            checkContext = checkContext.getParent();
        }
        return false;
    }

    private void executeDefine(Lexer lexer, int startOffset) throws OffsetLimitReachedException {
        try {
            ObjectStyleMacro macrodef = this.fMacroDefinitionParser.parseMacroDefinition(lexer, this);
            this.fMacroDictionary.put(macrodef.getNameCharArray(), (Object)macrodef);
            Token name = this.fMacroDefinitionParser.getNameToken();
            this.fLocationMap.encounterPoundDefine(startOffset, name.getOffset(), name.getEndOffset(), macrodef.getExpansionOffset(), macrodef.getExpansionEndOffset(), macrodef);
        }
        catch (MacroDefinitionParser.InvalidMacroDefinitionException e) {
            lexer.consumeLine(2);
            this.handleProblem(0x2000005, e.fName, e.fStartOffset, e.fEndOffset);
        }
    }

    private void executeUndefine(Lexer lexer, int startOffset) throws OffsetLimitReachedException {
        Token name = lexer.nextToken();
        int tt = name.getType();
        if (tt != 1) {
            if (tt == 140) {
                throw new OffsetLimitReachedException(2, name);
            }
            lexer.consumeLine(2);
            this.handleProblem(0x2000005, name.getCharImage(), startOffset, name.getEndOffset());
            return;
        }
        lexer.consumeLine(2);
        int endOffset = lexer.currentToken().getEndOffset();
        char[] namechars = name.getCharImage();
        PreprocessorMacro definition = (PreprocessorMacro)this.fMacroDictionary.remove(namechars, 0, namechars.length);
        this.fLocationMap.encounterPoundUndef(definition, startOffset, name.getOffset(), name.getEndOffset(), endOffset, namechars);
    }

    private void executeIfdef(Lexer lexer, int startOffset, boolean positive) throws OffsetLimitReachedException {
        Token name = lexer.nextToken();
        int tt = name.getType();
        if (tt != 1) {
            if (tt == 140) {
                throw new OffsetLimitReachedException(2, name);
            }
            lexer.consumeLine(2);
            this.handleProblem(0x2000003, name.getCharImage(), startOffset, name.getEndOffset());
            return;
        }
        lexer.consumeLine(2);
        int endOffset = lexer.currentToken().getEndOffset();
        char[] namechars = name.getCharImage();
        PreprocessorMacro macro = (PreprocessorMacro)this.fMacroDictionary.get(namechars);
        boolean isActive = macro != null == positive;
        this.fCurrentContext.changeBranch(ScannerContext.BRANCH_IF);
        if (positive) {
            this.fLocationMap.encounterPoundIfdef(startOffset, name.getOffset(), name.getEndOffset(), endOffset, isActive, macro);
        } else {
            this.fLocationMap.encounterPoundIfndef(startOffset, name.getOffset(), name.getEndOffset(), endOffset, isActive, macro);
        }
        if (macro == null == positive) {
            this.skipOverConditionalCode(lexer, true);
        }
    }

    private void executeIf(Lexer lexer, int startOffset) throws OffsetLimitReachedException {
        boolean isActive = false;
        TokenList condition = new TokenList();
        int condOffset = lexer.nextToken().getOffset();
        int condEndOffset = this.getTokensWithinPPDirective(lexer, true, condition);
        int endOffset = lexer.currentToken().getEndOffset();
        this.fExpressionEvaluator.clearMacrosInDefinedExpression();
        if (condition.first() == null) {
            this.handleProblem(0x100000C, null, startOffset, endOffset);
        } else {
            try {
                isActive = this.fExpressionEvaluator.evaluate(condition, this.fMacroDictionary, this.fLocationMap);
            }
            catch (ExpressionEvaluator.EvalException e) {
                this.handleProblem(e.getProblemID(), e.getProblemArg(), condOffset, endOffset);
            }
        }
        this.fCurrentContext.changeBranch(ScannerContext.BRANCH_IF);
        this.fLocationMap.encounterPoundIf(startOffset, condOffset, condEndOffset, endOffset, isActive, this.fExpressionEvaluator.clearMacrosInDefinedExpression());
        if (!isActive) {
            this.skipOverConditionalCode(lexer, true);
        }
    }

    private int getTokensWithinPPDirective(Lexer lexer, boolean isCondition, TokenList result) throws OffsetLimitReachedException {
        ScannerContext scannerCtx = this.fCurrentContext;
        boolean expandMacros = true;
        block6: while (true) {
            Token t = this.internalFetchToken(expandMacros, isCondition, true, false, scannerCtx);
            switch (t.getType()) {
                case 140: 
                case 144: {
                    lexer.consumeLine(2);
                    break block6;
                }
                case -99: {
                    break block6;
                }
                case 1: {
                    if (!isCondition || !CharArrayUtils.equals((char[])Keywords.cDEFINED, (char[])t.getCharImage())) break;
                    t.setType(-200);
                    expandMacros = false;
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    expandMacros = true;
                }
            }
            result.append(t);
        }
        return lexer.consumeLine(2);
    }

    private void skipOverConditionalCode(Lexer lexer, boolean takeElseBranch) throws OffsetLimitReachedException {
        int nesting = 0;
        block12: while (true) {
            Token pound;
            int tt;
            if ((tt = (pound = lexer.nextDirective()).getType()) != 138) {
                if (tt == 140) {
                    throw new OffsetLimitReachedException(3, pound);
                }
                return;
            }
            Token ident = lexer.nextToken();
            tt = ident.getType();
            if (tt != 1) {
                if (tt == 140) {
                    throw new OffsetLimitReachedException(3, ident);
                }
                lexer.consumeLine(2);
                continue;
            }
            char[] name = ident.getCharImage();
            int type = this.fPPKeywords.get(name);
            switch (type) {
                case 6: 
                case 12: {
                    this.executeInclude(lexer, ident.getOffset(), false, false, null);
                    continue block12;
                }
                case 11: {
                    this.executeInclude(lexer, ident.getOffset(), true, false, null);
                    continue block12;
                }
                case 1: {
                    lexer.consumeLine(2);
                    int endOffset = lexer.currentToken().getEndOffset();
                    ++nesting;
                    this.fCurrentContext.changeBranch(ScannerContext.BRANCH_IF);
                    this.fLocationMap.encounterPoundIfdef(pound.getOffset(), ident.getOffset(), ident.getEndOffset(), endOffset, false, null);
                    continue block12;
                }
                case 2: {
                    lexer.consumeLine(2);
                    int endOffset = lexer.currentToken().getEndOffset();
                    ++nesting;
                    this.fCurrentContext.changeBranch(ScannerContext.BRANCH_IF);
                    this.fLocationMap.encounterPoundIfndef(pound.getOffset(), ident.getOffset(), ident.getEndOffset(), endOffset, false, null);
                    continue block12;
                }
                case 0: {
                    int condEndOffset = lexer.consumeLine(2);
                    int endOffset = lexer.currentToken().getEndOffset();
                    ++nesting;
                    this.fCurrentContext.changeBranch(ScannerContext.BRANCH_IF);
                    this.fLocationMap.encounterPoundIf(pound.getOffset(), ident.getOffset(), condEndOffset, endOffset, false, IASTName.EMPTY_NAME_ARRAY);
                    continue block12;
                }
                case 4: {
                    boolean isActive;
                    lexer.consumeLine(2);
                    if (this.fCurrentContext.changeBranch(ScannerContext.BRANCH_ELSE)) {
                        isActive = nesting == 0 && takeElseBranch;
                        this.fLocationMap.encounterPoundElse(pound.getOffset(), ident.getEndOffset(), isActive);
                        if (!isActive) continue block12;
                        return;
                    }
                    this.handleProblem(0x2000004, name, pound.getOffset(), ident.getEndOffset());
                    continue block12;
                }
                case 3: {
                    boolean isActive;
                    int condEndOffset;
                    int endOffset;
                    if (this.fCurrentContext.changeBranch(ScannerContext.BRANCH_ELIF)) {
                        isActive = false;
                        this.fExpressionEvaluator.clearMacrosInDefinedExpression();
                        int condOffset = lexer.nextToken().getOffset();
                        if (nesting == 0 && takeElseBranch) {
                            TokenList condition = new TokenList();
                            condEndOffset = this.getTokensWithinPPDirective(lexer, true, condition);
                            if (condition.first() != null) {
                                try {
                                    isActive = this.fExpressionEvaluator.evaluate(condition, this.fMacroDictionary, this.fLocationMap);
                                }
                                catch (ExpressionEvaluator.EvalException e) {
                                    this.handleProblem(e.getProblemID(), e.getProblemArg(), condOffset, condEndOffset);
                                }
                            }
                        } else {
                            condEndOffset = lexer.consumeLine(2);
                        }
                        endOffset = lexer.currentToken().getEndOffset();
                        this.fCurrentContext.changeBranch(ScannerContext.BRANCH_ELIF);
                        this.fLocationMap.encounterPoundElif(pound.getOffset(), condOffset, condEndOffset, endOffset, isActive, this.fExpressionEvaluator.clearMacrosInDefinedExpression());
                        if (!isActive) continue block12;
                        return;
                    }
                    lexer.consumeLine(2);
                    endOffset = lexer.currentToken().getEndOffset();
                    this.handleProblem(0x2000004, name, pound.getOffset(), endOffset);
                    continue block12;
                }
                case 5: {
                    lexer.consumeLine(2);
                    if (this.fCurrentContext.changeBranch(ScannerContext.BRANCH_END)) {
                        this.fLocationMap.encounterPoundEndIf(pound.getOffset(), ident.getEndOffset());
                        if (nesting == 0) {
                            return;
                        }
                        --nesting;
                        continue block12;
                    }
                    this.handleProblem(0x2000004, name, pound.getOffset(), ident.getEndOffset());
                    continue block12;
                }
            }
            lexer.consumeLine(2);
        }
    }

    private boolean expandMacro(Token identifier, Lexer lexer, boolean stopAtNewline, boolean isPPCondition) throws OffsetLimitReachedException {
        char[] name = identifier.getCharImage();
        PreprocessorMacro macro = (PreprocessorMacro)this.fMacroDictionary.get(name);
        if (macro == null) {
            return false;
        }
        if (macro instanceof FunctionStyleMacro) {
            Token t = lexer.currentToken();
            TokenList newlines = new TokenList();
            if (!stopAtNewline) {
                while (t.getType() == -99) {
                    newlines.append(t);
                    t = lexer.nextToken();
                }
            }
            if (t.getType() != 8) {
                this.fPreobtainedTokens.appendAll(newlines);
                return false;
            }
        }
        boolean contentAssist = this.fContentAssistLimit >= 0 && this.fCurrentContext == this.fRootContext;
        TokenList replacement = this.fMacroExpander.expand(lexer, stopAtNewline, isPPCondition, macro, identifier, contentAssist);
        IASTName[] expansions = this.fMacroExpander.clearImplicitExpansions();
        ImageLocationInfo[] ili = this.fMacroExpander.clearImageLocationInfos();
        Token last = replacement.last();
        int length = last == null ? 0 : last.getEndOffset();
        ILocationCtx ctx = this.fLocationMap.pushMacroExpansion(identifier.getOffset(), identifier.getEndOffset(), lexer.getLastEndOffset(), length, macro, expansions, ili);
        this.fCurrentContext = new ScannerContext(ctx, this.fCurrentContext, replacement);
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.fMacroExpander.getClass())) {
            return this.fMacroExpander;
        }
        return null;
    }

    private static interface IIncludeFileTester<T> {
        public T checkFile(String var1, String var2);
    }
}

