/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.samples;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.objectteams.otdt.internal.samples.OTSamplesPlugin;
import org.eclipse.objectteams.otdt.internal.samples.SampleMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class SampleRunner {
    private ILaunchShortcut launchShortcut;
    final String sampleId;

    public SampleRunner(String sampleId) {
        this.sampleId = sampleId;
    }

    void doRun(String launcher, String target, boolean debug) {
        try {
            final ILaunchShortcut fshortcut = this.getLaunchShortcut(launcher);
            Object launchSelection = this.getLaunchSelection(target);
            StructuredSelection selection = launchSelection != null ? new StructuredSelection(launchSelection) : new StructuredSelection();
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable((ISelection)selection, debug){
                private final /* synthetic */ ISelection val$selection;
                private final /* synthetic */ boolean val$debug;
                {
                    this.val$selection = iSelection;
                    this.val$debug = bl;
                }

                @Override
                public void run() {
                    fshortcut.launch(this.val$selection, this.val$debug ? "debug" : "run");
                }
            });
        }
        catch (CoreException ex) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SampleMessages.SamplesAdapter_unable_to_run, (String)SampleMessages.SamplesAdapter_cannot_run_selected, (IStatus)ex.getStatus());
            OTSamplesPlugin.getDefault().getLog().log(ex.getStatus());
        }
    }

    private ILaunchShortcut getLaunchShortcut(String launcher) throws CoreException {
        if (this.launchShortcut != null && this.launchShortcut.getClass().getName().equals(launcher)) {
            return this.launchShortcut;
        }
        try {
            Class<?> launcherClass = Class.forName(launcher);
            this.launchShortcut = (ILaunchShortcut)launcherClass.newInstance();
            return this.launchShortcut;
        }
        catch (Exception ex) {
            Status status = OTSamplesPlugin.createErrorStatus("Unable to create launcher", ex);
            throw new CoreException((IStatus)status);
        }
    }

    Object getLaunchSelection(String target) throws JavaModelException {
        IJavaProject javaProject;
        IProject project = this.getProject(this.sampleId);
        if (project != null && (javaProject = JavaCore.create((IProject)project)).exists()) {
            IType targetType;
            if (target != null && (targetType = javaProject.findType(target)) != null) {
                return targetType;
            }
            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < packageFragmentRoots.length) {
                IPackageFragmentRoot root = packageFragmentRoots[i];
                if (root.getKind() == 1) {
                    return root;
                }
                ++i;
            }
        }
        return null;
    }

    IProject getProject(String sid) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        if (sid == null) {
            return null;
        }
        int i = 0;
        while (i < projects.length) {
            IFile pfile;
            IProject project = projects[i];
            if (project.exists() && project.isOpen() && (pfile = project.getFile("sample.properties")).exists()) {
                try {
                    InputStream is = pfile.getContents();
                    Properties prop = new Properties();
                    prop.load(is);
                    is.close();
                    String id = prop.getProperty("id");
                    if (id != null && id.equals(sid)) {
                        return project;
                    }
                }
                catch (IOException e) {
                    OTSamplesPlugin.logException(e, null, null);
                }
                catch (CoreException e) {
                    OTSamplesPlugin.logException(e, null, null);
                }
            }
            ++i;
        }
        return null;
    }
}

