/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
implements Flushable,
Closeable {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private InputStream is;
    private int current;
    private byte[] buffer;
    private int fill;
    private int pos;
    private int avail;

    public BitInputStream(InputStream is) {
        this.is = is;
        this.buffer = new byte[16384];
    }

    @Override
    public void flush() {
        this.avail = 0;
        this.pos = 0;
        this.fill = 0;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.is = null;
        this.buffer = null;
    }

    private int read() throws IOException {
        if (this.avail == 0) {
            this.avail = this.is.read(this.buffer);
            if (this.avail == -1) {
                this.avail = 0;
                throw new EOFException();
            }
            this.pos = 0;
        }
        --this.avail;
        return this.buffer[this.pos++] & 0xFF;
    }

    private int readFromCurrent(int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.fill == 0) {
            this.current = this.read();
            this.fill = 8;
        }
        return this.current >>> (this.fill -= len) & (1 << len) - 1;
    }

    public int readBit() throws IOException {
        return this.readFromCurrent(1);
    }

    public int readInt(int len) throws IOException {
        int x = 0;
        if (len <= this.fill) {
            return this.readFromCurrent(len);
        }
        x = this.readFromCurrent(this.fill);
        int i = (len -= this.fill) >> 3;
        while (i-- != 0) {
            x = x << 8 | this.read();
        }
        return x << (len &= 7) | this.readFromCurrent(len);
    }
}

