/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.editor.hover.ProblemHover;
import org.eclipse.xtend.shared.ui.editor.navigation.GenericHyperlinkDetector;

public abstract class AbstractXtendXpandSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final String DIALOG_SETTINGS = "org.eclipse.xtend.shared.uiDIALOG_SETTINGS";
    private final IEditorPart editor;

    public IEditorPart getEditor() {
        return this.editor;
    }

    public AbstractXtendXpandSourceViewerConfiguration(IEditorPart editor, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.editor = editor;
    }

    public AbstractXtendXpandSourceViewerConfiguration(IEditorPart editor) {
        this.editor = editor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new ProblemHover(sourceViewer);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{new GenericHyperlinkDetector(this.getEditor())};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        this.createContentAssistProcessor(contentAssistant);
        this.configureContentAssistant(contentAssistant, sourceViewer);
        return contentAssistant;
    }

    protected abstract void createContentAssistProcessor(ContentAssistant var1);

    protected void configureContentAssistant(ContentAssistant assistant, ISourceViewer sourceViewer) {
        ISharedTextColors sharedTextColors = EditorsUI.getSharedTextColors();
        Color white = sharedTextColors.getColor(new RGB(255, 255, 255));
        Color black = sharedTextColors.getColor(new RGB(0, 0, 0));
        assistant.setContextInformationPopupBackground(white);
        assistant.setContextInformationPopupForeground(black);
        assistant.setContextSelectorBackground(white);
        assistant.setContextSelectorForeground(black);
        assistant.setProposalSelectorBackground(white);
        assistant.setProposalSelectorForeground(black);
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(200);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings fSettings = settings.getSection(DIALOG_SETTINGS);
        if (fSettings == null) {
            fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(fSettings);
        }
        assistant.setRestoreCompletionProposalSize(fSettings);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public void refresh() {
    }
}

