/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.html.ui.internal.search.HTMLFindOccurrencesProcessor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.search.FindOccurrencesProcessor;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public class HTMLFindOccurrencesHandler
extends AbstractHandler
implements IHandler {
    private List fProcessors;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextSelection textSelection;
        FindOccurrencesProcessor findOccurrenceProcessor;
        IDocument document;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        boolean okay = false;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null && (findOccurrenceProcessor = this.getProcessorForCurrentSelection(document, textSelection = this.getTextSelection(textEditor))) != null && textEditor.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
            okay = findOccurrenceProcessor.findOccurrences(document, textSelection, file);
        }
        if (okay) {
            PlatformStatusLineUtil.clearStatusLine();
        } else {
            String errorMessage = SSEUIMessages.FindOccurrencesActionProvider_0;
            if (textEditor instanceof StructuredTextEditor) {
                PlatformStatusLineUtil.displayTemporaryErrorMessage((ITextViewer)((StructuredTextEditor)textEditor).getTextViewer(), (String)errorMessage);
            } else {
                PlatformStatusLineUtil.displayErrorMessage((String)errorMessage);
                PlatformStatusLineUtil.addOneTimeClearListener();
            }
        }
        return null;
    }

    private FindOccurrencesProcessor getProcessorForCurrentSelection(IDocument document, ITextSelection textSelection) {
        ITypedRegion tr = this.getPartition(document, textSelection);
        String partition = tr != null ? tr.getType() : "";
        Iterator it = this.getProcessors().iterator();
        FindOccurrencesProcessor processor = null;
        while (it.hasNext()) {
            processor = (FindOccurrencesProcessor)it.next();
            if (!processor.enabledForParitition(partition)) continue;
            return processor;
        }
        List extendedFindOccurrencesProcessors = ExtendedConfigurationBuilder.getInstance().getConfigurations(FindOccurrencesProcessor.class.getName(), partition);
        int i = 0;
        while (i < extendedFindOccurrencesProcessors.size()) {
            Object o = extendedFindOccurrencesProcessors.get(i);
            if (o instanceof FindOccurrencesProcessor && (processor = (FindOccurrencesProcessor)o).enabledForParitition(partition)) {
                return processor;
            }
            ++i;
        }
        return null;
    }

    private ITypedRegion getPartition(IDocument document, ITextSelection textSelection) {
        ITypedRegion region = null;
        if (textSelection != null) {
            try {
                region = document.getPartition(textSelection.getOffset());
            }
            catch (BadLocationException badLocationException) {
                region = null;
            }
        }
        return region;
    }

    private ITextSelection getTextSelection(ITextEditor textEditor) {
        ITextSelection textSelection = null;
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty()) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }

    protected List getProcessors() {
        if (this.fProcessors == null) {
            this.fProcessors = new ArrayList();
            HTMLFindOccurrencesProcessor htmlProcessor = new HTMLFindOccurrencesProcessor();
            this.fProcessors.add(htmlProcessor);
        }
        return this.fProcessors;
    }
}

