import { Position } from './common/position';
import { Range } from './common/range';
import { TreeNode } from './rbTreeBase';
export interface ITextSnapshot {
    read(): string | null;
}
export declare const AverageBufferSize = 65535;
export declare function createUintArray(arr: number[]): Uint32Array | Uint16Array;
export declare class LineStarts {
    readonly lineStarts: Uint32Array | Uint16Array | number[];
    readonly cr: number;
    readonly lf: number;
    readonly crlf: number;
    readonly isBasicASCII: boolean;
    constructor(lineStarts: Uint32Array | Uint16Array | number[], cr: number, lf: number, crlf: number, isBasicASCII: boolean);
}
export declare function createLineStartsFast(str: string, readonly?: boolean): Uint32Array | Uint16Array | number[];
export declare function createLineStarts(r: number[], str: string): LineStarts;
export interface NodePosition {
    /**
     * Piece Index
     */
    node: TreeNode;
    /**
     * remainer in current piece.
    */
    remainder: number;
    /**
     * node start offset in document.
     */
    nodeStartOffset: number;
}
export interface BufferCursor {
    /**
     * Line number in current buffer
     */
    line: number;
    /**
     * Column number in current buffer
     */
    column: number;
}
export declare class Piece {
    readonly bufferIndex: number;
    readonly start: BufferCursor;
    readonly end: BufferCursor;
    readonly length: number;
    readonly lineFeedCnt: number;
    constructor(bufferIndex: number, start: BufferCursor, end: BufferCursor, lineFeedCnt: number, length: number);
}
export declare class StringBuffer {
    buffer: string;
    lineStarts: Uint32Array | Uint16Array | number[];
    constructor(buffer: string, lineStarts: Uint32Array | Uint16Array | number[]);
}
export declare class PieceTreeBase {
    root: TreeNode;
    protected _buffers: StringBuffer[];
    protected _lineCnt: number;
    protected _length: number;
    protected _EOL: string;
    protected _EOLLength: number;
    protected _EOLNormalized: boolean;
    private _lastChangeBufferPos;
    private _searchCache;
    private _lastVisitedLine;
    constructor(chunks: StringBuffer[], eol: '\r\n' | '\n', eolNormalized: boolean);
    create(chunks: StringBuffer[], eol: '\r\n' | '\n', eolNormalized: boolean): void;
    normalizeEOL(eol: '\r\n' | '\n'): void;
    getEOL(): string;
    setEOL(newEOL: '\r\n' | '\n'): void;
    createSnapshot(BOM: string): ITextSnapshot;
    equal(other: PieceTreeBase): boolean;
    getOffsetAt(lineNumber: number, column: number): number;
    getPositionAt(offset: number): Position;
    getValueInRange(range: Range, eol?: string): string;
    getValueInRange2(startPosition: NodePosition, endPosition: NodePosition): string;
    getLinesContent(): string[];
    getLength(): number;
    getLineCount(): number;
    /**
     * @param lineNumber 1 based
     */
    getLineContent(lineNumber: number): string;
    getLineCharCode(lineNumber: number, index: number): number;
    getLineLength(lineNumber: number): number;
    insert(offset: number, value: string, eolNormalized?: boolean): void;
    delete(offset: number, cnt: number): void;
    insertContentToNodeLeft(value: string, node: TreeNode): void;
    insertContentToNodeRight(value: string, node: TreeNode): void;
    positionInBuffer(node: TreeNode, remainder: number): BufferCursor;
    positionInBuffer(node: TreeNode, remainder: number, ret: BufferCursor): null;
    getLineFeedCnt(bufferIndex: number, start: BufferCursor, end: BufferCursor): number;
    offsetInBuffer(bufferIndex: number, cursor: BufferCursor): number;
    deleteNodes(nodes: TreeNode[]): void;
    createNewPieces(text: string): Piece[];
    getLinesRawContent(): string;
    getLineRawContent(lineNumber: number, endOffset?: number): string;
    computeBufferMetadata(): void;
    getIndexOf(node: TreeNode, accumulatedValue: number): {
        index: number;
        remainder: number;
    };
    getAccumulatedValue(node: TreeNode, index: number): number;
    deleteNodeTail(node: TreeNode, pos: BufferCursor): void;
    deleteNodeHead(node: TreeNode, pos: BufferCursor): void;
    shrinkNode(node: TreeNode, start: BufferCursor, end: BufferCursor): void;
    appendToNode(node: TreeNode, value: string): void;
    nodeAt(offset: number): NodePosition;
    nodeAt2(lineNumber: number, column: number): NodePosition;
    nodeCharCodeAt(node: TreeNode, offset: number): number;
    offsetOfNode(node: TreeNode): number;
    shouldCheckCRLF(): boolean;
    startWithLF(val: string | TreeNode): boolean;
    endWithCR(val: string | TreeNode): boolean;
    validateCRLFWithPrevNode(nextNode: TreeNode): void;
    validateCRLFWithNextNode(node: TreeNode): void;
    fixCRLF(prev: TreeNode, next: TreeNode): void;
    adjustCarriageReturnFromNext(value: string, node: TreeNode): boolean;
    iterate(node: TreeNode, callback: (node: TreeNode) => boolean): boolean;
    getNodeContent(node: TreeNode): any;
    getPieceContent(piece: Piece): string;
    /**
     *      node              node
     *     /  \              /  \
     *    a   b    <----   a    b
     *                         /
     *                        z
     */
    rbInsertRight(node: TreeNode | null, p: Piece): TreeNode;
    /**
     *      node              node
     *     /  \              /  \
     *    a   b     ---->   a    b
     *                       \
     *                        z
     */
    rbInsertLeft(node: TreeNode | null, p: Piece): TreeNode;
    getContentOfSubTree(node: TreeNode): string;
}
