/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractDebugAdapterLaunchShortcut;

public class NodeRunDebugLaunchShortcut
extends AbstractDebugAdapterLaunchShortcut {
    public NodeRunDebugLaunchShortcut() {
        super("org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug", "org.eclipse.wildwebdeveloper.js", true);
    }

    @Override
    public void configureLaunchConfiguration(File file, ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute("program", file.getAbsolutePath());
    }

    @Override
    public boolean match(ILaunchConfiguration launchConfig, File selectedFile) {
        try {
            return launchConfig.getAttribute("program", "").equals(selectedFile.getAbsolutePath());
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            return false;
        }
    }

    @Override
    protected IResource getLaunchableResource(IContainer container) {
        if (container == null) {
            return null;
        }
        try {
            IResource[] jsFiles = (IResource[])Arrays.stream(container.members()).filter(member -> member.getType() == 1 && member.getName().endsWith(".js")).toArray(IResource[]::new);
            if (jsFiles.length == 1) {
                return jsFiles[0];
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e));
        }
        return null;
    }
}

