/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import com.ibm.icu.text.DateFormat;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteCompareOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSChangeSetCollector;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

class OpenChangeSetAction
extends SynchronizeModelAction {
    protected OpenChangeSetAction(ISynchronizePageConfiguration configuration) {
        super(CVSUIMessages.OpenCommitSetAction_20, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.AndSyncInfoFilter(new FastSyncInfoFilter[]{new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return info.getLocal().getType() == 1;
            }
        }, new FastSyncInfoFilter.OrSyncInfoFilter(new FastSyncInfoFilter[]{new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{8, 12}), new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                return !info.getComparator().isThreeWay();
            }
        }})});
    }

    private ChangeSet getChangeSet(IStructuredSelection selection) {
        ChangeSet set;
        Object o;
        if (selection.size() == 1 && (o = selection.getFirstElement()) instanceof IAdaptable && (set = (ChangeSet)((IAdaptable)o).getAdapter(ChangeSet.class)) != null) {
            return set;
        }
        return this.getChangeSet(selection.toArray());
    }

    private ChangeSet getChangeSet(Object[] elements) {
        ChangeSet foundSet = null;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ChangeSet set = this.getChangeSet((ISynchronizeModelElement)object);
            if (set == null) {
                return null;
            }
            if (foundSet == null) {
                foundSet = set;
            } else if (foundSet != set) {
                return null;
            }
            ++n2;
        }
        return foundSet;
    }

    private ChangeSet getChangeSet(ISynchronizeModelElement element) {
        ChangeSet set;
        if (element == null) {
            return null;
        }
        if (element instanceof IAdaptable && (set = (ChangeSet)((IAdaptable)element).getAdapter(ChangeSet.class)) != null) {
            return set;
        }
        return this.getChangeSet((ISynchronizeModelElement)element.getParent());
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean enabled = super.updateSelection(selection);
        if (enabled) {
            ChangeSet set = this.getChangeSet(selection);
            return set != null;
        }
        return false;
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        return new SynchronizeModelOperation(configuration, elements){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SyncInfoSet set = this.getSyncInfoSet();
                SyncInfo[] infos = set.getSyncInfos();
                if (infos.length > 0) {
                    ICVSRepositoryLocation location = this.getLocation(infos[0]);
                    if (location == null) {
                        OpenChangeSetAction.this.handle((Exception)((Object)new CVSException(CVSUIMessages.OpenCommitSetAction_21)));
                        return;
                    }
                    RemoteCompareOperation.CompareTreeBuilder builder = new RemoteCompareOperation.CompareTreeBuilder(location, null, null);
                    if (this.buildTrees(builder, infos)) {
                        try {
                            builder.cacheContents(monitor);
                            builder.openCompareEditor(OpenChangeSetAction.this.getConfiguration().getSite().getPart().getSite().getPage(), this.getCompareTitle(), this.getCompareToolTip());
                        }
                        catch (CVSException e) {
                            OpenChangeSetAction.this.handle((Exception)((Object)e));
                            return;
                        }
                    }
                }
            }

            private String getCompareToolTip() {
                IDiffElement[] elements;
                IDiffElement[] iDiffElementArray = elements = OpenChangeSetAction.this.getSelectedDiffElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IDiffElement element = iDiffElementArray[n2];
                    while (element != null) {
                        if (element instanceof ChangeSetDiffNode) {
                            return ((ChangeSetDiffNode)element).getName();
                        }
                        element = element.getParent();
                    }
                    ++n2;
                }
                return null;
            }

            private String getCompareTitle() {
                Object[] elements = OpenChangeSetAction.this.getSelectedDiffElements();
                ChangeSet set = OpenChangeSetAction.this.getChangeSet(elements);
                if (set instanceof CheckedInChangeSet) {
                    CheckedInChangeSet cics = (CheckedInChangeSet)set;
                    String date = DateFormat.getDateTimeInstance().format(cics.getDate());
                    return NLS.bind((String)CVSUIMessages.OpenChangeSetAction_0, (Object[])new String[]{cics.getAuthor(), date});
                }
                return CVSUIMessages.OpenChangeSetAction_1;
            }

            private ICVSRepositoryLocation getLocation(SyncInfo info) {
                IResourceVariant remote = info.getRemote();
                if (remote == null) {
                    remote = info.getBase();
                }
                if (remote != null) {
                    return ((ICVSRemoteResource)remote).getRepository();
                }
                return null;
            }

            private boolean buildTrees(RemoteCompareOperation.CompareTreeBuilder builder, SyncInfo[] infos) {
                SyncInfo[] syncInfoArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceVariant predecessor;
                    SyncInfo info = syncInfoArray[n2];
                    IResourceVariant remote = info.getRemote();
                    if (remote == null) {
                        predecessor = info.getBase();
                        if (predecessor instanceof ICVSRemoteFile) {
                            builder.addToTrees((ICVSRemoteFile)predecessor, null);
                        }
                    } else if (remote instanceof ICVSRemoteFile) {
                        try {
                            predecessor = OpenChangeSetAction.this.getImmediatePredecessor(remote);
                            builder.addToTrees((ICVSRemoteFile)predecessor, (ICVSRemoteFile)remote);
                        }
                        catch (TeamException e) {
                            OpenChangeSetAction.this.handle((Exception)((Object)e));
                            return false;
                        }
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    private ICVSRemoteFile getImmediatePredecessor(IResourceVariant remote) throws TeamException {
        CVSChangeSetCollector changeSetCollector = this.getChangeSetCollector();
        if (changeSetCollector != null) {
            return changeSetCollector.getImmediatePredecessor((ICVSRemoteFile)remote);
        }
        return null;
    }

    private CVSChangeSetCollector getChangeSetCollector() {
        return (CVSChangeSetCollector)this.getConfiguration().getProperty("org.eclipse.team.cvs.ui.CVSCheckedInCollector");
    }
}

