/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ConfirmMergedOperation
extends CVSSubscriberOperation {
    public ConfirmMergedOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return NLS.bind((String)CVSUIMessages.SubscriberConfirmMergedAction_jobName, (Object[])new String[]{Integer.valueOf(syncSet.size()).toString()});
    }

    @Override
    protected void runWithProjectRule(IProject project, SyncInfoSet syncSet, IProgressMonitor monitor) throws CVSException {
        SyncInfo[] syncResources = syncSet.getSyncInfos();
        monitor.beginTask(null, 100 * syncResources.length);
        try {
            try {
                SyncInfo[] syncInfoArray = syncResources;
                int n = syncResources.length;
                int n2 = 0;
                while (n2 < n) {
                    SyncInfo info = syncInfoArray[n2];
                    this.makeOutgoing(info, Policy.subMonitorFor(monitor, 100));
                    ++n2;
                }
            }
            catch (TeamException e) {
                this.handle((Exception)((Object)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean makeOutgoing(SyncInfo info, IProgressMonitor monitor) throws CVSException, TeamException {
        monitor.beginTask(null, 100);
        try {
            SyncInfo parentInfo;
            CVSSyncInfo cvsInfo = this.getCVSSyncInfo(info);
            if (cvsInfo == null) {
                CVSUIPlugin.log(4, NLS.bind((String)CVSUIMessages.SubscriberConfirmMergedAction_0, (Object[])new String[]{info.getLocal().getFullPath().toString()}), null);
                return false;
            }
            ICVSFolder parent = CVSWorkspaceRoot.getCVSFolderFor((IContainer)cvsInfo.getLocal().getParent());
            if (!parent.isCVSFolder() && !this.makeOutgoing(parentInfo = cvsInfo.getSubscriber().getSyncInfo(parent.getIResource()), Policy.subMonitorFor(monitor, 20))) {
                return false;
            }
            IStatus status = cvsInfo.makeOutgoing(Policy.subMonitorFor(monitor, 80));
            if (status.getSeverity() == 4) {
                this.logError(status);
                return false;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }
}

