/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.RemoteResourceElement;
import org.eclipse.team.internal.ccvs.ui.model.RepositoryLocationSchedulingRule;
import org.eclipse.team.internal.ccvs.ui.operations.FetchMembersOperation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class RemoteFolderElement
extends RemoteResourceElement
implements IDeferredWorkbenchAdapter {
    @Override
    public String getLabel(Object o) {
        if (!(o instanceof ICVSRemoteFolder)) {
            return null;
        }
        ICVSRemoteFolder folder = (ICVSRemoteFolder)o;
        CVSTag tag = folder.getTag();
        if (tag != null && tag.getType() != 0 && folder.getRemoteParent() == null) {
            return NLS.bind((String)CVSUIMessages.RemoteFolderElement_nameAndTag, (Object[])new String[]{folder.getName(), tag.getName()});
        }
        return folder.getName();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (!(object instanceof ICVSRemoteFolder)) {
            return null;
        }
        ICVSRemoteFolder folder = (ICVSRemoteFolder)object;
        if (folder.isDefinedModule()) {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/module_rep.gif");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
    }

    @Override
    public Object[] fetchChildren(Object o, IProgressMonitor monitor) throws TeamException {
        if (!(o instanceof ICVSRemoteFolder)) {
            return new Object[0];
        }
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(NLS.bind((String)CVSUIMessages.RemoteFolderElement_fetchingRemoteChildren, (Object[])new String[]{this.getLabel(o)}), 100);
            ICVSRemoteFolder folder = (ICVSRemoteFolder)o;
            Object[] cachedChildren = CVSUIPlugin.getPlugin().getRepositoryManager().getCachedChildrenForTag(folder.getRepository(), folder, folder.getTag(), Policy.subMonitorFor(monitor, 50));
            if (cachedChildren.length > 0) {
                Object[] objectArray = cachedChildren;
                return objectArray;
            }
            Object[] objectArray = folder.members(Policy.subMonitorFor(monitor, 50));
            return objectArray;
        }
        finally {
            monitor.done();
        }
    }

    public void fetchDeferredChildren(Object o, IElementCollector collector, IProgressMonitor monitor) {
        if (!(o instanceof ICVSRemoteFolder)) {
            collector.add(new Object[0], monitor);
        }
        try {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(NLS.bind((String)CVSUIMessages.RemoteFolderElement_fetchingRemoteChildren, (Object[])new String[]{this.getLabel(o)}), 100);
            ICVSRemoteFolder folder = (ICVSRemoteFolder)o;
            Object[] cachedChildren = CVSUIPlugin.getPlugin().getRepositoryManager().getCachedChildrenForTag(folder.getRepository(), folder, folder.getTag(), Policy.subMonitorFor(monitor, 50));
            if (cachedChildren.length > 0) {
                collector.add(cachedChildren, monitor);
                return;
            }
            try {
                FetchMembersOperation operation = new FetchMembersOperation(null, folder, collector);
                operation.run(Policy.subMonitorFor(monitor, 50));
            }
            catch (InvocationTargetException e) {
                this.handle(collector, e);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CVSException e) {
                this.handle(collector, e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public ISchedulingRule getRule(Object element) {
        ICVSRepositoryLocation location = this.getRepositoryLocation(element);
        return new RepositoryLocationSchedulingRule(location);
    }

    private ICVSRepositoryLocation getRepositoryLocation(Object o) {
        if (!(o instanceof ICVSRemoteFolder)) {
            return null;
        }
        return ((ICVSRemoteFolder)o).getRepository();
    }

    public boolean isContainer() {
        return true;
    }
}

