/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.console;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.console.CVSConsoleFactory;
import org.eclipse.team.internal.ccvs.ui.console.ConsoleDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class CVSOutputConsole
extends MessageConsole
implements org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener,
IPropertyChangeListener {
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private long commandStarted = 0L;
    private MessageConsoleStream commandStream;
    private MessageConsoleStream messageStream;
    private MessageConsoleStream errorStream;
    private boolean showOnMessage = CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_console_show_on_message");
    private ConsoleDocument document = new ConsoleDocument();
    private IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
    private static final DateFormat TIME_FORMAT;
    private boolean visible = false;
    private boolean initialized = false;
    private static final String NESTING = "   ";

    static {
        SimpleDateFormat format;
        try {
            format = new SimpleDateFormat(CVSUIMessages.Console_resultTimeFormat);
        }
        catch (RuntimeException runtimeException) {
            format = new SimpleDateFormat("'(took 'm:ss.SSS')')");
        }
        TIME_FORMAT = format;
    }

    public CVSOutputConsole() {
        super("CVS", CVSUIPlugin.getPlugin().getImageDescriptor("eview16/console_view.gif"));
        CVSProviderPlugin.getPlugin().setConsoleListener((org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener)this);
        CVSUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void init() {
        super.init();
        this.initLimitOutput();
        this.initWrapSetting();
        CVSUIPlugin.getStandardDisplay().asyncExec(() -> {
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.initializeStreams();
            this.dump();
        });
    }

    private void initWrapSetting() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        if (store.getBoolean("pref_console_wrap")) {
            this.setConsoleWidth(store.getInt("pref_console_width"));
        } else {
            this.setConsoleWidth(-1);
        }
    }

    private void initLimitOutput() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        if (store.getBoolean("pref_console_limit_output")) {
            this.setWaterMarks(1000, store.getInt("pref_console_high_water_mark"));
        } else {
            this.setWaterMarks(-1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                this.commandStream = this.newMessageStream();
                this.errorStream = this.newMessageStream();
                this.messageStream = this.newMessageStream();
                this.commandColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(this.commandColor);
                this.messageColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(this.messageColor);
                this.errorColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(this.errorColor);
                Font f = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("pref_console_font");
                this.setFont(f);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            ConsoleDocument.ConsoleLine[] lines;
            this.visible = true;
            ConsoleDocument.ConsoleLine[] consoleLineArray = lines = this.document.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleDocument.ConsoleLine line = consoleLineArray[n2];
                this.appendLine(line.type, line.line);
                ++n2;
            }
            this.document.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(int type, String line) {
        this.showConsole();
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                switch (type) {
                    case 0: {
                        this.commandStream.println(line);
                        break;
                    }
                    case 1: {
                        this.messageStream.println("  " + line);
                        break;
                    }
                    case 2: {
                        this.errorStream.println("  " + line);
                    }
                }
            } else {
                this.document.appendConsoleLine(type, line);
            }
        }
    }

    private void showConsole() {
        this.show(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public void shutdown() {
        super.dispose();
        if (this.commandColor != null) {
            this.commandColor.dispose();
        }
        if (this.messageColor != null) {
            this.messageColor.dispose();
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
        CVSUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void commandInvoked(Session session, String line) {
        if (!session.isOutputToConsole()) {
            return;
        }
        this.commandStarted = System.currentTimeMillis();
        this.appendLine(0, CVSUIMessages.Console_preExecutionDelimiter);
        this.appendLine(0, line);
    }

    public void messageLineReceived(Session session, String line, IStatus status) {
        if (session.isOutputToConsole()) {
            this.appendLine(1, "  " + line);
        }
    }

    public void errorLineReceived(Session session, String line, IStatus status) {
        if (session.isOutputToConsole()) {
            this.appendLine(2, "  " + line);
        }
    }

    public void commandCompleted(Session session, IStatus status, Exception exception) {
        String time;
        if (!session.isOutputToConsole()) {
            return;
        }
        long commandRuntime = System.currentTimeMillis() - this.commandStarted;
        try {
            time = TIME_FORMAT.format(new Date(commandRuntime));
        }
        catch (RuntimeException e) {
            CVSUIPlugin.log(4, CVSUIMessages.Console_couldNotFormatTime, e);
            time = "";
        }
        if (status != null) {
            String statusText;
            boolean includeRoot = true;
            if (status.getCode() == -10) {
                statusText = NLS.bind((String)CVSUIMessages.Console_resultServerError, (Object[])new String[]{status.getMessage(), time});
                includeRoot = false;
            } else {
                statusText = NLS.bind((String)CVSUIMessages.Console_resultOk, (Object[])new String[]{time});
            }
            this.appendLine(0, statusText);
            this.outputStatus(status, includeRoot, includeRoot ? 0 : 1);
        } else if (exception != null) {
            String statusText = exception instanceof OperationCanceledException ? NLS.bind((String)CVSUIMessages.Console_resultAborted, (Object[])new String[]{time}) : NLS.bind((String)CVSUIMessages.Console_resultException, (Object[])new String[]{time});
            this.appendLine(0, statusText);
            if (exception instanceof CoreException) {
                this.outputStatus(((CoreException)((Object)exception)).getStatus(), true, 1);
            }
        } else {
            String statusText = NLS.bind((String)CVSUIMessages.Console_resultOk, (Object[])new String[]{time});
        }
        this.appendLine(0, CVSUIMessages.Console_postExecutionDelimiter);
        this.appendLine(0, "");
    }

    private void outputStatus(IStatus status, boolean includeParent, int nestingLevel) {
        IStatus[] children;
        Throwable t;
        if (includeParent && !status.isOK()) {
            this.outputStatusMessage(status, nestingLevel);
            ++nestingLevel;
        }
        if ((t = status.getException()) instanceof CoreException) {
            this.outputStatus(((CoreException)t).getStatus(), true, nestingLevel);
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus c = iStatusArray[n2];
            this.outputStatus(c, true, nestingLevel);
            ++n2;
        }
    }

    private void outputStatusMessage(IStatus status, int nesting) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING);
            ++i;
        }
        buffer.append(this.messageLineForStatus(status));
        this.appendLine(0, buffer.toString());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.visible) {
            Color newColor;
            if (property.equals("pref_console_command_color")) {
                newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(newColor);
                this.commandColor.dispose();
                this.commandColor = newColor;
            } else if (property.equals("pref_console_message_color")) {
                newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(newColor);
                this.messageColor.dispose();
                this.messageColor = newColor;
            } else if (property.equals("pref_console_error_color")) {
                newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(newColor);
                this.errorColor.dispose();
                this.errorColor = newColor;
            } else if (property.equals("pref_console_font")) {
                this.setFont(((FontRegistry)event.getSource()).get("pref_console_font"));
            }
        }
        if (property.equals("pref_console_show_on_message")) {
            Object value = event.getNewValue();
            this.showOnMessage = value instanceof String ? Boolean.valueOf((String)value).booleanValue() : ((Boolean)value).booleanValue();
        } else if (property.equals("pref_console_limit_output")) {
            this.initLimitOutput();
        } else if (property.equals("pref_console_wrap")) {
            this.initWrapSetting();
        }
    }

    private String messageLineForStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return NLS.bind((String)CVSUIMessages.Console_error, (Object[])new String[]{status.getMessage()});
        }
        if (status.getSeverity() == 2) {
            return NLS.bind((String)CVSUIMessages.Console_warning, (Object[])new String[]{status.getMessage()});
        }
        if (status.getSeverity() == 1) {
            return NLS.bind((String)CVSUIMessages.Console_info, (Object[])new String[]{status.getMessage()});
        }
        return status.getMessage();
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)CVSUIPlugin.getPlugin().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    public void show(boolean showNoMatterWhat) {
        if (showNoMatterWhat || this.showOnMessage) {
            if (!this.visible) {
                CVSConsoleFactory.showConsole();
            } else {
                this.consoleManager.showConsoleView((IConsole)this);
            }
        }
    }

    public String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.console_view_context";
    }

    public class MyLifecycle
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == CVSOutputConsole.this) {
                    CVSOutputConsole.this.init();
                }
                ++n2;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == CVSOutputConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    CVSOutputConsole.this.dispose();
                }
                ++n2;
            }
        }
    }
}

