/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.util.FileNameMatcher;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.ui.PlatformUI;

public class IgnoreResourcesDialog
extends TitleAreaDialog {
    private IResource[] resources;
    private final String ACTION_KEY = "Action";
    private static final int ADD_NAME_ENTRY = 0;
    private static final int ADD_EXTENSION_ENTRY = 1;
    private static final int ADD_CUSTOM_ENTRY = 2;
    private IDialogSettings settings;
    private Button addNameEntryButton;
    private Button addExtensionEntryButton;
    private Button addCustomEntryButton;
    private Text customEntryText;
    private int selectedAction;
    private String customPattern;
    private static final int LABEL_INDENT_WIDTH = 32;
    private Image dlgTitleImage = null;
    private boolean resourceWithSpaces = false;
    private boolean allResourecesHaveExtensions = true;
    private boolean allResourcesWithSpacesHaveExtensions = true;

    public IgnoreResourcesDialog(Shell shell, IResource[] resources) {
        super(shell);
        this.resources = resources;
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("IgnoreResourcesDialog");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("IgnoreResourcesDialog");
        }
        try {
            this.selectedAction = this.settings.getInt("Action");
        }
        catch (NumberFormatException numberFormatException) {
            this.selectedAction = 0;
        }
        this.resourceWithSpaces = this.checkForResourcesWithSpaces();
        this.allResourecesHaveExtensions = this.checkIfAllResourcesHaveExtensions();
        this.allResourcesWithSpacesHaveExtensions = this.checkIfAllResourcesWithSpacesHaveExtensions();
    }

    public String getIgnorePatternFor(IResource resource) {
        switch (this.selectedAction) {
            case 0: {
                return resource.getName();
            }
            case 1: {
                String extension = resource.getFileExtension();
                return extension == null ? resource.getName() : "*." + extension;
            }
            case 2: {
                return this.customPattern;
            }
        }
        throw new IllegalStateException();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CVSUIMessages.IgnoreResourcesDialog_dialogTitle);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.dlgTitleImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.png").createImage();
        this.setTitleImage(this.dlgTitleImage);
        this.updateEnablements();
        this.setTitle(CVSUIMessages.IgnoreResourcesDialog_title);
        this.setErrorMessage(null);
        this.setDefaultMessage();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, "org.eclipse.team.cvs.ui.add_to_cvsignore_context");
        Listener selectionListener = event -> this.updateEnablements();
        Listener modifyListener = event -> this.validate();
        this.addNameEntryButton = this.createRadioButton(top, CVSUIMessages.IgnoreResourcesDialog_addNameEntryButton);
        this.addNameEntryButton.addListener(13, selectionListener);
        this.addNameEntryButton.setSelection(this.selectedAction == 0);
        Label addNameEntryLabel = this.createIndentedLabel(top, CVSUIMessages.IgnoreResourcesDialog_addNameEntryExample, 32);
        this.addExtensionEntryButton = this.createRadioButton(top, CVSUIMessages.IgnoreResourcesDialog_addExtensionEntryButton);
        this.addExtensionEntryButton.addListener(13, selectionListener);
        this.addExtensionEntryButton.setSelection(this.selectedAction == 1);
        Label addExtensionEntryLabel = this.createIndentedLabel(top, CVSUIMessages.IgnoreResourcesDialog_addExtensionEntryExample, 32);
        this.addCustomEntryButton = this.createRadioButton(top, CVSUIMessages.IgnoreResourcesDialog_addCustomEntryButton);
        this.addCustomEntryButton.addListener(13, selectionListener);
        this.addCustomEntryButton.setSelection(this.selectedAction == 2);
        this.createIndentedLabel(top, CVSUIMessages.IgnoreResourcesDialog_addCustomEntryExample, 32);
        if (this.resourceWithSpaces) {
            this.customEntryText = this.createIndentedText(top, this.getResourceWithSpace().getName().replaceAll(" ", "?"), 32);
            ControlDecoration customEntryTextDecoration = new ControlDecoration((Control)this.customEntryText, 16512);
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            FieldDecoration infoDecoration = registry.getFieldDecoration("DEC_INFORMATION");
            customEntryTextDecoration.setImage(infoDecoration.getImage());
            customEntryTextDecoration.setDescriptionText(CVSUIMessages.IgnoreResourcesDialog_filesWithSpaceWarning);
            customEntryTextDecoration.setShowOnlyOnFocus(false);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 32 + FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
            this.customEntryText.setLayoutData((Object)gridData);
            this.customEntryText.setFocus();
            this.addNameEntryButton.setEnabled(false);
            addNameEntryLabel.setEnabled(false);
            if (!this.addCustomEntryButton.getSelection()) {
                this.addNameEntryButton.setSelection(false);
                this.addCustomEntryButton.setSelection(true);
                this.selectedAction = 2;
            }
            if (!this.allResourcesWithSpacesHaveExtensions) {
                this.addExtensionEntryButton.setEnabled(false);
                addExtensionEntryLabel.setEnabled(false);
                this.addExtensionEntryButton.setSelection(false);
                this.addCustomEntryButton.setSelection(true);
                this.selectedAction = 2;
            }
        } else {
            this.customEntryText = this.createIndentedText(top, this.resources[0].getName(), 32);
        }
        this.customEntryText.addListener(24, modifyListener);
        IgnoreResourcesDialog.applyDialogFont((Control)top);
        return top;
    }

    protected void okPressed() {
        this.settings.put("Action", this.selectedAction);
        super.okPressed();
    }

    private Label createIndentedLabel(Composite parent, String text, int indent) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData(784);
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createIndentedText(Composite parent, String text, int indent) {
        Text textbox = new Text(parent, 2048);
        textbox.setText(text);
        GridData data = new GridData(256);
        data.horizontalIndent = indent;
        textbox.setLayoutData((Object)data);
        return textbox;
    }

    private Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setLayoutData((Object)new GridData(784));
        return button;
    }

    private void updateEnablements() {
        if (this.addNameEntryButton.getSelection()) {
            this.selectedAction = 0;
        } else if (this.addExtensionEntryButton.getSelection()) {
            this.selectedAction = 1;
        } else if (this.addCustomEntryButton.getSelection()) {
            this.selectedAction = 2;
        }
        this.customEntryText.setEnabled(this.selectedAction == 2);
        this.validate();
    }

    private void validate() {
        if (this.selectedAction == 2) {
            this.customPattern = this.customEntryText.getText();
            if (this.customPattern.length() == 0) {
                this.setError(CVSUIMessages.IgnoreResourcesDialog_patternMustNotBeEmpty);
                return;
            }
            FileNameMatcher matcher = new FileNameMatcher(new String[]{this.customPattern});
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String name = resource.getName();
                if (!matcher.match(name)) {
                    this.setError(NLS.bind((String)CVSUIMessages.IgnoreResourcesDialog_patternDoesNotMatchFile, (Object[])new String[]{name}));
                    return;
                }
                ++n2;
            }
            if (this.resourceWithSpaces) {
                this.setWarning(CVSUIMessages.IgnoreResourcesDialog_filesWithSpaceWarningMessage);
                return;
            }
        } else if (this.selectedAction == 1 && !this.allResourecesHaveExtensions) {
            this.setWarning(CVSUIMessages.IgnoreResourcesDialog_filesWithNoExtensionWarningMessage);
            return;
        }
        this.setError(null);
    }

    private void setError(String text) {
        this.setErrorMessage(text);
        if (text == null) {
            this.setDefaultMessage();
        }
        this.getButton(0).setEnabled(text == null);
    }

    private void setWarning(String text) {
        this.setError(null);
        this.setMessage(text, 2);
    }

    private void setDefaultMessage() {
        if (this.resources.length == 1) {
            this.setMessage(NLS.bind((String)CVSUIMessages.IgnoreResourcesDialog_messageSingle, (Object[])new String[]{this.resources[0].getName()}));
        } else {
            this.setMessage(NLS.bind((String)CVSUIMessages.IgnoreResourcesDialog_messageMany, (Object[])new String[]{Integer.toString(this.resources.length)}));
        }
    }

    private boolean checkForResourcesWithSpaces() {
        return this.getResourceWithSpace() != null;
    }

    private IResource getResourceWithSpace() {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().contains(" ")) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    private boolean checkIfAllResourcesWithSpacesHaveExtensions() {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().contains(" ") && resource.getFileExtension() == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkIfAllResourcesHaveExtensions() {
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getFileExtension() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }
}

