/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;

public abstract class OMPDFS {
    protected OMPCFGNode startNode_ = null;
    protected HashSet visited_ = new HashSet();
    protected Stack currentNodes_ = new Stack();
    public static final int CONTINUE = 0;
    public static final int SKIP = 1;
    public static final int ABORT = 2;

    public OMPDFS(OMPCFGNode startNode) {
        this.startNode_ = startNode;
    }

    public void startWalking() {
        this.walkDFS(this.startNode_);
    }

    protected int walkDFS(OMPCFGNode node) {
        if (this.visited_.contains(node)) {
            return 0;
        }
        this.currentNodes_.push(node);
        int code = this.visit(node);
        this.visited_.add(node);
        if (code == 1) {
            this.currentNodes_.pop();
            return 0;
        }
        if (code == 2) {
            this.currentNodes_.pop();
            return 2;
        }
        OMPCFGNode[] outNodes = node.getOutNodes();
        int i = 0;
        while (i < outNodes.length) {
            int iCode = this.walkDFS(outNodes[i]);
            if (iCode == 2) {
                this.currentNodes_.pop();
                return 2;
            }
            ++i;
        }
        this.currentNodes_.pop();
        return 0;
    }

    public OMPCFGNode[] getNodeStack() {
        OMPCFGNode[] l = new OMPCFGNode[this.currentNodes_.size()];
        int count = 0;
        Iterator i = this.currentNodes_.iterator();
        while (i.hasNext()) {
            l[count++] = (OMPCFGNode)i.next();
        }
        return l;
    }

    public int getNodeStackSize() {
        return this.currentNodes_.size();
    }

    public boolean isVisited(OMPCFGNode node) {
        return this.visited_.contains(node);
    }

    public abstract int visit(OMPCFGNode var1);
}

