/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.etfw.feedback.views.SimpleTreeTableMarkerView;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.Activator;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PerfSuiteFeedbackView
extends SimpleTreeTableMarkerView {
    private static boolean CREATE_PARENT_NODES = true;
    private static String[] attrNames = new String[]{"name", "filename", "itemID", "lineNumber", "description"};
    private static String[] colNames = new String[]{"Module", "File", "Function", "LineNo", "Number of Samples"};
    private static int[] widths = new int[]{320, 160, 160, 70, 70};
    protected IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    protected boolean maintainExpandCollapseState = this.preferenceStore.getBoolean("maintainExpandCollapseState");

    public PerfSuiteFeedbackView() {
        super((AbstractUIPlugin)Activator.getDefault(), "profile", "lines", attrNames, colNames, widths, "org.eclipse.ptp.etfw.feedback.perfsuite.marker", "parent", CREATE_PARENT_NODES);
    }

    public String extractMarkerInfo(IMarker marker) {
        StringBuffer infoBuffer = new StringBuffer();
        String filename = marker.getResource().getName();
        String modulename = this.getStrAttr(marker, "name");
        String functionname = this.getStrAttr(marker, "itemID");
        infoBuffer.append("\nDetails:\n");
        infoBuffer.append("\nModule name: ").append(modulename);
        infoBuffer.append("\nFile name: ").append(filename);
        infoBuffer.append("\nFunction name: ").append(functionname);
        infoBuffer.append("\nLine number: ").append(this.getStrAttr(marker, "lineNumber"));
        infoBuffer.append("\n\nNumber of samples: ").append(this.getStrAttr(marker, "description"));
        return infoBuffer.toString();
    }

    public String getStrAttr(IMarker marker, String attrName) {
        try {
            String str = marker.getAttribute(attrName).toString();
            return str;
        }
        catch (CoreException e) {
            System.out.println("Exception getting marker attr in PerfSuiteFeedbackView.getStrAttr() " + e.getMessage());
            return "*error*";
        }
    }

    protected void maintainExpandCollapseStatus() {
        this.maintainExpandCollapseState = this.preferenceStore.getBoolean("maintainExpandCollapseState");
        if (this.maintainExpandCollapseState) {
            switch (this.expandCollapseStatus) {
                case 1: {
                    this.expandAllAction.run();
                    break;
                }
                case 2: {
                    this.collapseAllAction.run();
                }
            }
        }
    }
}

