/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.sdm.core.pdi;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDICondition;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDILocation;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIAddressBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExceptionpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILineBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.debug.core.pdi.model.IPDIWatchpoint;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.internal.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.internal.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.internal.debug.sdm.core.messages.Messages;
import org.eclipse.ptp.internal.debug.sdm.core.proxy.ProxyDebugClient;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEventListener;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemotePortForwardingService;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.core.launch.IRemoteLaunchConfigService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDIDebugger
extends ProxyDebugClient
implements IPDIDebugger {
    private int bpid = 0;
    private int fForwardedPort = -1;
    private IRemoteConnection fRemoteConnection = null;

    public void addEventManager(IPDIEventManager eventManager) throws PDIException {
        if (eventManager instanceof IProxyDebugEventListener) {
            this.addProxyDebugEventListener((IProxyDebugEventListener)eventManager);
        }
    }

    public void commandRequest(TaskSet tasks, String command) throws PDIException {
        try {
            this.debugCLIHandle(tasks, command);
        }
        catch (IOException e) {
            throw new PDIException(null, String.valueOf(Messages.PDIDebugger_0) + e.getMessage());
        }
    }

    public void createDataReadMemory(TaskSet tasks, long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) throws PDIException {
        try {
            this.setDataReadMemoryCommand(tasks, offset, address, this.getFormat(wordFormat), wordSize, rows, cols, asChar);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_1) + e.getMessage());
        }
    }

    public void createDataWriteMemory(TaskSet tasks, long offset, String address, int wordFormat, int wordSize, String value) throws PDIException {
        try {
            this.setDataWriteMemoryCommand(tasks, offset, address, this.getFormat(wordFormat), wordSize, value);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_2) + e.getMessage());
        }
    }

    public void deleteBreakpoint(TaskSet tasks, int bpid) throws PDIException {
        try {
            this.debugDeleteBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_3) + e.getMessage());
        }
    }

    public void deletePartialExpression(TaskSet tasks, String var) throws PDIException {
        try {
            this.debugDeletePartialExpression(tasks, var);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_4) + e.getMessage());
        }
    }

    public void evaluateExpression(TaskSet tasks, String expr) throws PDIException {
        try {
            this.debugEvaluateExpression(tasks, expr);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_5) + e.getMessage());
        }
    }

    public void evaluatePartialExpression(TaskSet tasks, String expr, String exprId, boolean listChildren, boolean express) throws PDIException {
        try {
            this.debugEvaluatePartialExpression(tasks, expr, exprId, listChildren, express);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_6) + e.getMessage());
        }
    }

    public int getErrorAction(int errorCode) {
        switch (errorCode) {
            case 4: 
            case 5: 
            case 26: 
            case 33: {
                return 2;
            }
            case 12: 
            case 13: 
            case 38: {
                return 0;
            }
            case 39: {
                return 3;
            }
        }
        return 1;
    }

    public void initialize(ILaunchConfiguration configuration, List<String> args, IProgressMonitor monitor) throws PDIException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            int level;
            int port = 0;
            for (String arg : args) {
                if (!arg.startsWith("--port=")) continue;
                try {
                    port = Integer.parseInt(arg.substring(7, arg.length()));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            try {
                this.doInitialize(port);
            }
            catch (IOException e) {
                throw new PDIException(null, String.valueOf(Messages.PDIDebugger_7) + e.getMessage());
            }
            try {
                this.fRemoteConnection = this.getRemoteConnection(configuration, (IProgressMonitor)progress.newChild(5));
            }
            catch (CoreException e) {
                throw new PDIException(null, e.getMessage());
            }
            if (progress.isCanceled()) {
                throw new PDIException(null, Messages.PDIDebugger_Operation_canceled_by_user);
            }
            if (this.fRemoteConnection != null) {
                port = this.getSessionPort();
                IRemotePortForwardingService portForwarding = (IRemotePortForwardingService)this.fRemoteConnection.getService(IRemotePortForwardingService.class);
                if (portForwarding != null) {
                    try {
                        this.fForwardedPort = port = portForwarding.forwardRemotePort("", this.getSessionPort(), (IProgressMonitor)progress.newChild(5));
                    }
                    catch (RemoteConnectionException e) {
                        throw new PDIException(null, e.getMessage());
                    }
                    if (progress.isCanceled()) {
                        throw new PDIException(null, Messages.PDIDebugger_Operation_canceled_by_user);
                    }
                }
            } else {
                throw new PDIException(null, Messages.PDIDebugger_8);
            }
            args.add("--port=" + port);
            if (Preferences.getBoolean((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_ENABLED) && ((level = Preferences.getInt((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUG_LEVEL)) & 0x40) == 64) {
                this.getDebugOptions().PROTOCOL_TRACING = true;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private IRemoteConnection getRemoteConnection(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRemoteLaunchConfigService launchConfigService = SDMDebugCorePlugin.getService(IRemoteLaunchConfigService.class);
        return launchConfigService.getActiveConnection(configuration);
    }

    public boolean isConnected(IProgressMonitor monitor) throws PDIException {
        block3: {
            try {
                if (!this.waitConnect(monitor)) break block3;
                this.sessionHandleEvents();
                return true;
            }
            catch (IOException e) {
                this.stopDebugger();
                throw new PDIException(null, String.valueOf(Messages.PDIDebugger_12) + e.getMessage());
            }
        }
        this.stopDebugger();
        return false;
    }

    public void listArguments(TaskSet tasks, int low, int high) throws PDIException {
        try {
            this.debugListArguments(tasks, low, high);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_13) + e.getMessage());
        }
    }

    public void listGlobalVariables(TaskSet tasks) throws PDIException {
        try {
            this.debugListGlobalVariables(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_14) + e.getMessage());
        }
    }

    public void listInfoThreads(TaskSet tasks) throws PDIException {
        try {
            this.debugListInfoThreads(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_15) + e.getMessage());
        }
    }

    public void listLocalVariables(TaskSet tasks) throws PDIException {
        try {
            this.debugListLocalVariables(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_16) + e.getMessage());
        }
    }

    public void listSignals(TaskSet tasks, String name) throws PDIException {
        try {
            this.debugListSignals(tasks, name);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_17) + e.getMessage());
        }
    }

    public void listStackFrames(TaskSet tasks, int low, int depth) throws PDIException {
        try {
            this.debugListStackframes(tasks, low, depth);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_18) + e.getMessage());
        }
    }

    public void removeEventManager(IPDIEventManager eventManager) throws PDIException {
        if (eventManager instanceof IProxyDebugEventListener) {
            this.removeProxyDebugEventListener((IProxyDebugEventListener)eventManager);
        }
    }

    public void restart(TaskSet tasks) throws PDIException {
        throw new PDIException(null, Messages.PDIDebugger_19);
    }

    public void resume(TaskSet tasks, boolean passSignal) throws PDIException {
        try {
            this.debugGo(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_20) + e.getMessage());
        }
    }

    public void resume(TaskSet tasks, IPDILocation location) throws PDIException {
        throw new PDIException(null, Messages.PDIDebugger_21);
    }

    public void resume(TaskSet tasks, IPDISignal signal) throws PDIException {
        throw new PDIException(null, Messages.PDIDebugger_22);
    }

    public void retrieveStackInfoDepth(TaskSet tasks) throws PDIException {
        try {
            this.debugStackInfoDepth(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_24) + e.getMessage());
        }
    }

    public void retrieveVariableType(TaskSet tasks, String var) throws PDIException {
        try {
            this.debugGetType(tasks, var);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_25) + e.getMessage());
        }
    }

    public void selectThread(TaskSet tasks, int tid) throws PDIException {
        try {
            this.debugSetThreadSelect(tasks, tid);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_26) + e.getMessage());
        }
    }

    public void setAddressBreakpoint(TaskSet tasks, IPDIAddressBreakpoint bpt) throws PDIException {
        throw new PDIException(tasks, Messages.PDIDebugger_27);
    }

    public void setConditionBreakpoint(TaskSet tasks, int bpid, String condition) throws PDIException {
        try {
            this.debugConditionBreakpoint(tasks, bpid, condition);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_28) + e.getMessage());
        }
    }

    public void setCurrentStackFrame(TaskSet tasks, int level) throws PDIException {
        try {
            this.debugSetCurrentStackframe(tasks, level);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_29) + e.getMessage());
        }
    }

    public void setEnabledBreakpoint(TaskSet tasks, int bpid, boolean enabled) throws PDIException {
        try {
            if (enabled) {
                this.debugEnableBreakpoint(tasks, bpid);
            } else {
                this.debugDisableBreakpoint(tasks, bpid);
            }
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_30) + e.getMessage());
        }
    }

    public void setExceptionpoint(TaskSet tasks, IPDIExceptionpoint bpt) throws PDIException {
        throw new PDIException(tasks, Messages.PDIDebugger_31);
    }

    public void setFunctionBreakpoint(TaskSet tasks, IPDIFunctionBreakpoint bpt) throws PDIException {
        try {
            IPDICondition condition = bpt.getCondition();
            int id = bpt.getBreakpointID();
            if (id == -1) {
                id = this.newBreakpointId();
                bpt.setBreakpointID(id);
            }
            this.debugSetFuncBreakpoint(tasks, id, bpt.isTemporary(), bpt.isHardware(), this.getFilename(bpt.getLocator().getFile()), bpt.getLocator().getFunction(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_32) + e.getMessage());
        }
    }

    public void setLineBreakpoint(TaskSet tasks, IPDILineBreakpoint bpt) throws PDIException {
        try {
            IPDICondition condition = bpt.getCondition();
            int id = bpt.getBreakpointID();
            if (id == -1) {
                id = this.newBreakpointId();
                bpt.setBreakpointID(id);
            }
            this.debugSetLineBreakpoint(tasks, id, bpt.isTemporary(), bpt.isHardware(), this.getFilename(bpt.getLocator().getFile()), bpt.getLocator().getLineNumber(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_33) + e.getMessage());
        }
    }

    public void setWatchpoint(TaskSet tasks, IPDIWatchpoint bpt) throws PDIException {
        try {
            String expression = bpt.getWatchExpression();
            boolean access = bpt.isReadType() && bpt.isWriteType();
            boolean read = !bpt.isWriteType() && bpt.isReadType();
            IPDICondition condition = bpt.getCondition();
            int id = bpt.getBreakpointID();
            if (id == -1) {
                id = this.newBreakpointId();
                bpt.setBreakpointID(id);
            }
            this.debugSetWatchpoint(tasks, id, expression, access, read, condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_34) + e.getMessage());
        }
    }

    public void start(TaskSet tasks) throws PDIException {
        this.resume(tasks, false);
    }

    public void startDebugger(String app, String path, String dir, String[] args) throws PDIException {
        try {
            this.debugStartSession(app, path, dir, args);
        }
        catch (IOException e) {
            throw new PDIException(null, String.valueOf(Messages.PDIDebugger_35) + e.getMessage());
        }
    }

    public void stepInto(TaskSet tasks, int count) throws PDIException {
        try {
            this.debugStep(tasks, count, 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_36) + e.getMessage());
        }
    }

    public void stepIntoInstruction(TaskSet tasks, int count) throws PDIException {
        throw new PDIException(null, Messages.PDIDebugger_37);
    }

    public void stepOver(TaskSet tasks, int count) throws PDIException {
        try {
            this.debugStep(tasks, count, 1);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_38) + e.getMessage());
        }
    }

    public void stepOverInstruction(TaskSet tasks, int count) throws PDIException {
        throw new PDIException(null, Messages.PDIDebugger_39);
    }

    public void stepReturn(TaskSet tasks, IAIF aif) throws PDIException {
        throw new PDIException(null, Messages.PDIDebugger_40);
    }

    public void stepReturn(TaskSet tasks, int count) throws PDIException {
        try {
            this.debugStep(tasks, count, 2);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_41) + e.getMessage());
        }
    }

    public void stepUntil(TaskSet tasks, IPDILocation location) throws PDIException {
        throw new PDIException(null, Messages.PDIDebugger_42);
    }

    public void stopDebugger() throws PDIException {
        block4: {
            try {
                IRemotePortForwardingService portForwarding;
                this.doShutdown();
                if (this.fForwardedPort < 0 || this.fRemoteConnection == null || (portForwarding = (IRemotePortForwardingService)this.fRemoteConnection.getService(IRemotePortForwardingService.class)) == null) break block4;
                try {
                    portForwarding.removeRemotePortForwarding(this.fForwardedPort);
                }
                catch (RemoteConnectionException e) {
                    SDMDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), 4, e.getLocalizedMessage(), null));
                }
                this.fForwardedPort = -1;
            }
            catch (IOException e) {
                throw new PDIException(null, String.valueOf(Messages.PDIDebugger_43) + e.getMessage());
            }
        }
    }

    public void suspend(TaskSet tasks) throws PDIException {
        try {
            this.debugInterrupt(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_44) + e.getMessage());
        }
    }

    public void terminate(TaskSet tasks) throws PDIException {
        try {
            this.debugTerminate(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, String.valueOf(Messages.PDIDebugger_45) + e.getMessage());
        }
    }

    private String getFilename(String fullPath) {
        Path path = new Path(fullPath);
        if (path.isEmpty()) {
            return "";
        }
        return path.lastSegment();
    }

    private String getFormat(int wordFormat) {
        switch (wordFormat) {
            case 15: {
                return "u";
            }
            case 10: {
                return "f";
            }
            case 11: {
                return "a";
            }
            case 12: {
                return "i";
            }
            case 13: {
                return "c";
            }
            case 14: {
                return "s";
            }
            case 3: {
                return "d";
            }
            case 2: {
                return "t";
            }
            case 1: {
                return "o";
            }
        }
        return "x";
    }

    private int newBreakpointId() {
        return this.bpid++;
    }
}

