/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.OomphDropAdapter;
import org.eclipse.oomph.internal.ui.OomphEditingDomain;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.swt.widgets.Widget;

public final class GeneralDropAdapter
extends OomphDropAdapter {
    private final EObject containerObject;

    public GeneralDropAdapter(Viewer viewer, EObject containerObject, EReference containmentFeature, DroppedObjectHandler handler) {
        super(GeneralDropAdapter.createEditingDomain(containerObject, containmentFeature, handler), viewer, OomphTransferDelegate.DELEGATES);
        this.containerObject = containerObject;
    }

    protected Object extractDropTarget(Widget item) {
        return this.containerObject;
    }

    private static EditingDomain createEditingDomain(final EObject containerObject, final EReference containmentFeature, final DroppedObjectHandler handler) {
        if (!containmentFeature.isMany()) {
            throw new IllegalArgumentException("Not many-valued: " + containmentFeature);
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        OomphEditingDomain editingDomain = new OomphEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack(), (Map)new HashMap(), (List)OomphTransferDelegate.DELEGATES){

            public Command createCommand(Class<? extends Command> commandClass, CommandParameter commandParameter) {
                Object owner;
                if (commandClass == CopyCommand.class && ((ComposedAdapterFactory)this.adapterFactory).getFactoryForType(owner = commandParameter.getOwner()) == null) {
                    return new IdentityCommand(owner);
                }
                return super.createCommand(commandClass, commandParameter);
            }
        };
        containerObject.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.isTouch()) {
                    return;
                }
                if (msg.getFeature() == containmentFeature && msg.getEventType() == 3) {
                    EList list = (EList)containerObject.eGet((EStructuralFeature)containmentFeature);
                    Object droppedObject = list.get(0);
                    list.clear();
                    try {
                        handler.handleDroppedObject(droppedObject);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        ResourceSet resourceSet = editingDomain.getResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createURI((String)"container.list"));
        resource.getContents().add((Object)containerObject);
        return editingDomain;
    }

    public static interface DroppedObjectHandler {
        public void handleDroppedObject(Object var1) throws Exception;
    }
}

