/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.AbstractHotfixOperation;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;

public final class HotfixStartOperation
extends AbstractHotfixOperation {
    public HotfixStartOperation(GitFlowRepository repository, String hotfixName) {
        super(repository, hotfixName);
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        GitFlowConfig config = this.repository.getConfig();
        String branchName = config.getHotfixBranchName(this.versionName);
        RevCommit head = this.repository.findHead(config.getMaster());
        if (head == null) {
            throw new IllegalStateException(NLS.bind((String)CoreText.StartOperation_unableToFindCommitFor, (Object)config.getDevelop()));
        }
        this.start(monitor, branchName, head);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

