/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.IEEFDomainClassTester;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class EEFDomainClassTester
implements IEEFDomainClassTester {
    private static final Pattern SEPARATOR = Pattern.compile("(::?|\\.)");

    @Override
    public boolean eInstanceOf(EObject eObject, String domainClass) {
        String packageName = null;
        String className = null;
        if (!Util.isBlank((String)domainClass)) {
            Matcher m = SEPARATOR.matcher(domainClass);
            if (m.find()) {
                packageName = domainClass.substring(0, m.start());
                className = domainClass.substring(m.end());
            } else {
                className = domainClass;
            }
            if (!("EObject".equals(className) && packageName == null || "EObject".equals(className) && "ecore".equals(packageName))) {
                boolean result = false;
                ArrayList<EClass> eAllTypes = new ArrayList<EClass>();
                eAllTypes.add(eObject.eClass());
                eAllTypes.addAll((Collection<EClass>)eObject.eClass().getEAllSuperTypes());
                Iterator iterator = eAllTypes.iterator();
                while (iterator.hasNext() && !result) {
                    EClass eClass = (EClass)iterator.next();
                    if (packageName == null && className != null) {
                        result = className.equals(eClass.getName());
                        continue;
                    }
                    if (packageName == null || className == null) continue;
                    boolean bl = result = packageName.equals(eClass.getEPackage().getName()) && className.equals(eClass.getName());
                }
                return result;
            }
        }
        return true;
    }
}

