/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteLogOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.LogEntryCacheUpdateHandler;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class CVSChangeSetCollector
extends SyncInfoSetChangeSetCollector
implements LogEntryCacheUpdateHandler.ILogsFetchedListener {
    public static final String CVS_CHECKED_IN_COLLECTOR = "org.eclipse.team.cvs.ui.CVSCheckedInCollector";
    private static final String LOG_ENTRY_HANDLER = "org.eclipse.team.cvs.ui.LogEntryHandler";
    private static final String DEFAULT_INCOMING_SET_NAME = CVSUIMessages.CVSChangeSetCollector_0;
    boolean disposed = false;
    private RemoteLogOperation.LogEntryCache logEntryCache;

    public CVSChangeSetCollector(ISynchronizePageConfiguration configuration) {
        super(configuration);
        configuration.setProperty(CVS_CHECKED_IN_COLLECTOR, (Object)this);
    }

    public synchronized LogEntryCacheUpdateHandler getLogEntryHandler() {
        LogEntryCacheUpdateHandler handler = (LogEntryCacheUpdateHandler)((Object)this.getConfiguration().getProperty(LOG_ENTRY_HANDLER));
        if (handler == null) {
            handler = this.initializeLogEntryHandler(this.getConfiguration());
        }
        handler.setListener(this);
        return handler;
    }

    private LogEntryCacheUpdateHandler initializeLogEntryHandler(final ISynchronizePageConfiguration configuration) {
        LogEntryCacheUpdateHandler logEntryHandler = new LogEntryCacheUpdateHandler(configuration);
        configuration.setProperty(LOG_ENTRY_HANDLER, (Object)logEntryHandler);
        configuration.addActionContribution(new SynchronizePageActionGroup(){

            public void dispose() {
                super.dispose();
                LogEntryCacheUpdateHandler handler = (LogEntryCacheUpdateHandler)((Object)configuration.getProperty(CVSChangeSetCollector.LOG_ENTRY_HANDLER));
                if (handler != null) {
                    handler.shutdown();
                    configuration.setProperty(CVSChangeSetCollector.LOG_ENTRY_HANDLER, null);
                }
            }
        });
        return logEntryHandler;
    }

    protected void add(SyncInfo[] infos) {
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            try {
                handler.fetch(infos);
            }
            catch (CVSException e) {
                this.getConfiguration().getSyncInfoSet().addError((ITeamStatus)new TeamStatus(4, "org.eclipse.team.cvs.ui", 0, e.getMessage(), (Throwable)e, null));
            }
        }
    }

    public void reset(SyncInfoSet seedSet) {
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            handler.stopFetching();
        }
        super.reset(seedSet);
    }

    public void dispose() {
        this.disposed = true;
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            handler.setListener(null);
        }
        this.getConfiguration().setProperty(CVS_CHECKED_IN_COLLECTOR, null);
        this.logEntryCache = null;
        super.dispose();
    }

    private void handleRemoteChanges(SyncInfo[] infos, RemoteLogOperation.LogEntryCache logEntries, IProgressMonitor monitor) {
        this.performUpdate(monitor1 -> this.addLogEntries(infos, logEntries, monitor1), true, monitor);
    }

    private void addLogEntries(SyncInfo[] commentInfos, RemoteLogOperation.LogEntryCache logs, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, commentInfos.length * 10);
            if (logs != null) {
                SyncInfo[] syncInfoArray = commentInfos;
                int n = commentInfos.length;
                int n2 = 0;
                while (n2 < n) {
                    SyncInfo commentInfo = syncInfoArray[n2];
                    this.addSyncInfoToCommentNode(commentInfo, logs);
                    monitor.worked(10);
                    ++n2;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addSyncInfoToCommentNode(SyncInfo info, RemoteLogOperation.LogEntryCache logs) {
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            ICVSRemoteResource remoteResource = handler.getRemoteResource(info);
            if (handler.getSubscriber() instanceof CVSCompareSubscriber && remoteResource != null) {
                this.addMultipleRevisions(info, logs, remoteResource);
            } else {
                this.addSingleRevision(info, logs, remoteResource);
            }
        }
    }

    private void addSingleRevision(SyncInfo info, RemoteLogOperation.LogEntryCache logs, ICVSRemoteResource remoteResource) {
        ILogEntry logEntry = logs.getLogEntry(remoteResource);
        if (remoteResource != null && !remoteResource.isFolder()) {
            try {
                String remoteRevision = ((ICVSRemoteFile)remoteResource).getRevision();
                if (this.isDeletedRemotely(info)) {
                    ILogEntry[] logEntries;
                    ILogEntry[] iLogEntryArray = logEntries = logs.getLogEntries(remoteResource);
                    int n = logEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILogEntry entry = iLogEntryArray[n2];
                        String revision = entry.getRevision();
                        if (entry.isDeletion() && ResourceSyncInfo.isLaterRevision((String)revision, (String)remoteRevision)) {
                            logEntry = entry;
                        }
                        ++n2;
                    }
                }
            }
            catch (TeamException teamException) {}
        }
        this.addRemoteChange(info, remoteResource, logEntry);
    }

    private void addMultipleRevisions(SyncInfo info, RemoteLogOperation.LogEntryCache logs, ICVSRemoteResource remoteResource) {
        ILogEntry[] logEntries = logs.getLogEntries(remoteResource);
        if (logEntries == null || logEntries.length == 0) {
            this.addRemoteChange(info, null, null);
        } else {
            ILogEntry[] iLogEntryArray = logEntries;
            int n = logEntries.length;
            int n2 = 0;
            while (n2 < n) {
                ILogEntry entry = iLogEntryArray[n2];
                this.addRemoteChange(info, remoteResource, entry);
                ++n2;
            }
        }
    }

    private boolean isDeletedRemotely(SyncInfo info) {
        int kind = info.getKind();
        if (kind == 10) {
            return true;
        }
        return SyncInfo.getDirection((int)kind) == 12 && info.getRemote() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteChange(SyncInfo info, ICVSRemoteResource remoteResource, ILogEntry logEntry) {
        if (this.disposed) {
            return;
        }
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null && remoteResource != null && logEntry != null && handler.isRemoteChange((SyncInfo)info)) {
            if (this.requiresCustomSyncInfo((SyncInfo)info, remoteResource, logEntry)) {
                info = new CVSUpdatableSyncInfo(info.getKind(), info.getLocal(), info.getBase(), (IResourceVariant)((RemoteResource)logEntry.getRemoteFile()), ((CVSSyncInfo)info).getSubscriber());
                try {
                    info.init();
                }
                catch (TeamException teamException) {}
            }
            IResourceVariant base = info.getBase();
            IResourceVariant remote = info.getRemote();
            if (base == null && remote != null || remote == null && base != null || remote != null && base != null && !base.equals((Object)remote)) {
                CVSChangeSetCollector cVSChangeSetCollector = this;
                synchronized (cVSChangeSetCollector) {
                    CheckedInChangeSet set = this.getChangeSetFor(logEntry);
                    if (set == null) {
                        set = this.createChangeSetFor(logEntry);
                        this.add((ChangeSet)set);
                    }
                    set.add(info);
                }
            }
        } else {
            this.addToDefaultSet(DEFAULT_INCOMING_SET_NAME, (SyncInfo)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDefaultSet(String name, SyncInfo info) {
        CVSChangeSetCollector cVSChangeSetCollector = this;
        synchronized (cVSChangeSetCollector) {
            CheckedInChangeSet set = this.getChangeSetFor(name);
            if (set == null) {
                set = this.createDefaultChangeSet(name);
                this.add((ChangeSet)set);
            }
            set.add(info);
        }
    }

    private CheckedInChangeSet createDefaultChangeSet(String name) {
        return new DefaultCheckedInChangeSet(name);
    }

    private CheckedInChangeSet createChangeSetFor(ILogEntry logEntry) {
        return new CVSCheckedInChangeSet(logEntry);
    }

    private CheckedInChangeSet getChangeSetFor(ILogEntry logEntry) {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            if (set instanceof CheckedInChangeSet && set.getComment().equals(logEntry.getComment()) && ((CheckedInChangeSet)set).getAuthor().equals(logEntry.getAuthor())) {
                return (CheckedInChangeSet)set;
            }
            ++n2;
        }
        return null;
    }

    private CheckedInChangeSet getChangeSetFor(String name) {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            if (set.getName().equals(name)) {
                return (CheckedInChangeSet)set;
            }
            ++n2;
        }
        return null;
    }

    private boolean requiresCustomSyncInfo(SyncInfo info, ICVSRemoteResource remoteResource, ILogEntry logEntry) {
        if (logEntry.isDeletion() || !(info instanceof CVSSyncInfo)) {
            return false;
        }
        IResourceVariant remote = info.getRemote();
        if (remote == null) {
            return true;
        }
        return !remote.equals((Object)remoteResource);
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        super.waitUntilDone(monitor);
        monitor.worked(1);
        LogEntryCacheUpdateHandler handler = this.getLogEntryHandler();
        if (handler != null) {
            while (handler.getEventHandlerJob().getState() != 0) {
                monitor.worked(1);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                Policy.checkCanceled(monitor);
            }
        }
        monitor.worked(1);
    }

    @Override
    public void logEntriesFetched(SyncInfoSet set, RemoteLogOperation.LogEntryCache logEntryCache, IProgressMonitor monitor) {
        if (this.disposed) {
            return;
        }
        this.logEntryCache = logEntryCache;
        this.handleRemoteChanges(set.getSyncInfos(), logEntryCache, monitor);
    }

    public ICVSRemoteFile getImmediatePredecessor(ICVSRemoteFile file) throws TeamException {
        if (this.logEntryCache != null) {
            return this.logEntryCache.getImmediatePredecessor(file);
        }
        return null;
    }

    protected void initializeSets() {
    }

    private class CVSCheckedInChangeSet
    extends CheckedInChangeSet {
        private final ILogEntry entry;

        public CVSCheckedInChangeSet(ILogEntry entry) {
            this.entry = entry;
            Date date = entry.getDate();
            String comment = Util.flattenText((String)entry.getComment());
            if (date == null) {
                this.setName("[" + entry.getAuthor() + "] " + comment);
            } else {
                String dateString = DateFormat.getDateTimeInstance().format(date);
                this.setName("[" + entry.getAuthor() + "] (" + dateString + ") " + comment);
            }
        }

        public String getAuthor() {
            return this.entry.getAuthor();
        }

        public Date getDate() {
            return this.entry.getDate();
        }

        public String getComment() {
            return this.entry.getComment();
        }
    }

    public class CVSUpdatableSyncInfo
    extends CVSSyncInfo {
        public int kind;

        public CVSUpdatableSyncInfo(int kind, IResource local, IResourceVariant base, IResourceVariant remote, Subscriber s) {
            super(local, base, remote, s);
            this.kind = kind;
        }

        protected int calculateKind() throws TeamException {
            return this.kind;
        }
    }

    private class DefaultCheckedInChangeSet
    extends CheckedInChangeSet {
        private Date date = new Date();

        public DefaultCheckedInChangeSet(String name) {
            this.setName(name);
        }

        public String getAuthor() {
            return "";
        }

        public Date getDate() {
            return this.date;
        }

        public String getComment() {
            return "";
        }
    }
}

