/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.ElementCreationWithMessageEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DurationLinkFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.DurationLinkUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.GeneralOrderingUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationUtil;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class ExecutionSpecificationGraphicalNodeEditPolicy
extends ElementCreationWithMessageEditPolicy {
    @Override
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        ExecutionSpecification execSpec;
        CreateRelationshipRequest createRequest;
        if ((DurationLinkUtil.isCreateDurationLink(request) || GeneralOrderingUtil.isCreateGeneralOrderingLink(request)) && (createRequest = DurationLinkUtil.getCreateRelationshipRequest(request)) != null && (execSpec = this.getExecutionSpecification()) != null) {
            OccurrenceSpecification sourceOccurrence = OccurrenceSpecificationUtil.isStart(this.getHostFigure(), request.getLocation()) ? execSpec.getStart() : execSpec.getFinish();
            Map extendedData = request.getExtendedData();
            extendedData.put("Source Occurrence", sourceOccurrence);
            createRequest.setParameter("Source Occurrence", (Object)sourceOccurrence);
        }
        return super.getConnectionCreateCommand(request);
    }

    private ExecutionSpecification getExecutionSpecification() {
        Object model = this.getHost().getModel();
        if (model instanceof View && ((View)model).getElement() instanceof ExecutionSpecification) {
            return (ExecutionSpecification)((View)model).getElement();
        }
        return null;
    }

    @Override
    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        ExecutionSpecification execSpec;
        CreateRelationshipRequest createRequest;
        if ((DurationLinkUtil.isCreateDurationLink((CreateConnectionRequest)request) || GeneralOrderingUtil.isCreateGeneralOrderingLink((CreateConnectionRequest)request)) && (createRequest = OccurrenceSpecificationUtil.getCreateRelationshipRequest((CreateConnectionRequest)request)) != null && (execSpec = this.getExecutionSpecification()) != null) {
            OccurrenceSpecification targetOccurrence = OccurrenceSpecificationUtil.isStart(this.getHostFigure(), request.getLocation()) ? execSpec.getStart() : execSpec.getFinish();
            Map extendedData = request.getExtendedData();
            extendedData.put("Target Occurrence", targetOccurrence);
            createRequest.setParameter("Target Occurrence", (Object)targetOccurrence);
        }
        return super.getConnectionAndRelationshipCompleteCommand(request);
    }

    @Override
    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return super.getReconnectSourceCommand(request);
    }

    @Override
    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return super.getReconnectTargetCommand(request);
    }

    @Override
    protected Connection createDummyConnection(Request req) {
        if (req instanceof CreateConnectionRequest && DurationLinkUtil.isCreateDurationLink((CreateConnectionRequest)req)) {
            return new DurationLinkFigure();
        }
        return new PolylineConnection();
    }
}

