/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.jdt.docker.launcher;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.messages.ExecCreation;
import java.io.File;
import java.nio.ByteBuffer;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.jdt.docker.launcher.UnixFile;
import org.osgi.framework.Version;

public class ImageQuery {
    private String id;
    private DockerClient client;
    private DockerConnection conn;

    public ImageQuery(DockerConnection conn, String image) {
        IDockerHostConfig hc = DockerHostConfig.builder().build();
        DockerContainerConfig cc = new DockerContainerConfig.Builder().image(image).cmd("/bin/sh").attachStdout(Boolean.valueOf(true)).attachStderr(Boolean.valueOf(true)).attachStdin(Boolean.valueOf(true)).openStdin(Boolean.valueOf(true)).tty(Boolean.valueOf(true)).build();
        try {
            this.id = conn.createContainer((IDockerContainerConfig)cc, hc);
            conn.startContainer(this.id, null);
            this.client = conn.getClient();
            this.conn = conn;
        }
        catch (DockerException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String exec(String[] cmd) {
        try (LogStream stream = null;){
            ExecCreation exeCr = this.client.execCreate(this.id, cmd, new DockerClient.ExecCreateParam[]{DockerClient.ExecCreateParam.attachStdout(), DockerClient.ExecCreateParam.attachStderr(), DockerClient.ExecCreateParam.detach(), DockerClient.ExecCreateParam.attachStdin()});
            stream = this.client.execStart(exeCr.id(), new DockerClient.ExecStartParameter[0]);
            StringBuilder res = new StringBuilder();
            while (stream.hasNext()) {
                ByteBuffer b = ((LogMessage)stream.next()).content();
                byte[] buffer = new byte[b.remaining()];
                b.get(buffer);
                res.append(new String(buffer));
            }
            String string = res.toString();
            return string;
        }
        return null;
    }

    public String getDefaultJVMName() {
        String result = null;
        File f = this.getDefaultJVMInstallLocation();
        if (f != null) {
            result = f.getName();
        }
        return result;
    }

    public File getDefaultJVMInstallLocation() {
        String JRE = "jre";
        String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
        String[] fgCandidateJavaLocations = new String[]{"jre/bin/", "bin/"};
        String result = this.exec(new String[]{"sh", "-c", "readlink -f `which java`"});
        if (result != null) {
            result = result.replaceAll("\n", "");
            int i = 0;
            while (i < fgCandidateJavaFiles.length) {
                int j = 0;
                while (j < fgCandidateJavaLocations.length) {
                    if (result.endsWith(String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i])) {
                        return new UnixFile(result.replace(String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i], ""));
                    }
                    ++j;
                }
                ++i;
            }
            result = this.exec(new String[]{"readlink", "-f", "/usr/lib/jvm/java"});
            if (result != null) {
                result = result.replaceAll("\n", "");
            }
            return new UnixFile(result);
        }
        return null;
    }

    public double getJavaVersion() {
        String result = this.exec(new String[]{"sh", "-c", "java -version 2>&1 | grep version | cut -d\\\" -f2 | cut -d_ -f1"});
        if (result != null) {
            result = result.replaceAll("\n", "");
            try {
                Version v = new Version(result);
                String newV = String.valueOf(v.getMajor()) + "." + v.getMinor();
                return Double.valueOf(newV);
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public boolean fileExists(File file) {
        String result = this.exec(new String[]{"sh", "-c", "[ -e " + file.getAbsolutePath() + " ]; echo $?"});
        try {
            result = result.replaceAll("\n", "");
            int res = Integer.parseInt(result);
            return res == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isFile(File file) {
        String result = this.exec(new String[]{"sh", "-c", "[ -f " + file.getAbsolutePath() + " ]; echo $?"});
        try {
            result = result.replaceAll("\n", "");
            int res = Integer.parseInt(result);
            return res == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void destroy() {
        try {
            this.conn.stopContainer(this.id);
            this.conn.removeContainer(this.id);
        }
        catch (DockerException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

