/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.ui.memory.transport.BufferedMemoryWriter;
import org.eclipse.cdt.debug.ui.memory.transport.ImportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.cdt.debug.ui.memory.transport.Messages;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryImporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PlainTextImporter
implements IMemoryImporter {
    File fInputFile;
    BigInteger fStartAddress;
    boolean fUseCustomAddress;
    Boolean fScrollToStart;
    private Text fStartText;
    private Text fFileText;
    private Button fScrollToBeginningOnImportComplete;
    private IMemoryBlock fMemoryBlock;
    private ImportMemoryDialog fParentDialog;
    private IDialogSettings fProperties;
    private static final int BUFFER_LENGTH = 65536;

    @Override
    public Control createControl(final Composite parent, IMemoryBlock memBlock, IDialogSettings properties, ImportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        this.fUseCustomAddress = true;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                PlainTextImporter.this.fProperties.put("File", PlainTextImporter.this.fFileText.getText().trim());
                PlainTextImporter.this.fProperties.put("Start", PlainTextImporter.this.fStartText.getText().trim());
                PlainTextImporter.this.fProperties.put("ScrollToStart", PlainTextImporter.this.fScrollToBeginningOnImportComplete.getSelection());
                try {
                    PlainTextImporter.this.fStartAddress = PlainTextImporter.this.getStartAddress();
                    PlainTextImporter.this.fInputFile = PlainTextImporter.this.getFile();
                    PlainTextImporter.this.fScrollToStart = PlainTextImporter.this.getScrollToStart();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        FormData data = new FormData();
        Label labelStartText = new Label(composite, 0);
        labelStartText.setText(Messages.getString("PlainTextImporter.RestoreAddress"));
        this.fStartText = new Text(composite, 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)labelStartText);
        data.width = 120;
        this.fStartText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 2048);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText(Messages.getString("Importer.File"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText(Messages.getString("Importer.Browse"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        String textValue = this.fProperties.get("File");
        this.fFileText.setText(textValue != null ? textValue : "");
        textValue = this.fProperties.get("Start");
        this.fStartText.setText(textValue != null ? textValue : "0x0");
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setText(Messages.getString("PlainTextImporter.ChooseFile"));
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{Messages.getString("Importer.AllFiles")});
                dialog.setFileName(PlainTextImporter.this.fFileText.getText().trim());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    PlainTextImporter.this.fFileText.setText(String.valueOf(dialog.getFilterPath()) + File.separator + filename);
                }
                PlainTextImporter.this.validate();
            }
        });
        this.fStartText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    PlainTextImporter.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                PlainTextImporter.this.fStartText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                PlainTextImporter.this.validate();
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PlainTextImporter.this.validate();
            }
        });
        this.fScrollToBeginningOnImportComplete = new Button(composite, 32);
        this.fScrollToBeginningOnImportComplete.setText(Messages.getString("PlainTextImporter.ScrollToStart"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton);
        this.fScrollToBeginningOnImportComplete.setLayoutData((Object)data);
        boolean scrollToStart = this.fProperties.getBoolean("ScrollToStart");
        this.fScrollToBeginningOnImportComplete.setSelection(scrollToStart);
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(() -> this.validate());
        return composite;
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getStartAddress();
            if (this.fFileText.getText().trim().length() == 0) {
                isValid = false;
            }
            if (!this.getFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public boolean getScrollToStart() {
        return this.fScrollToBeginningOnImportComplete.getSelection();
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = (text = text.trim()).startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText().trim());
    }

    @Override
    public String getId() {
        return "PlainTextImporter";
    }

    @Override
    public String getName() {
        return Messages.getString("PlainTextImporter.Name");
    }

    @Override
    public void importMemory() {
        Job job = new Job("Memory Import from Plain Text File"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BufferedMemoryWriter memoryWriter = new BufferedMemoryWriter((IMemoryBlockExtension)PlainTextImporter.this.fMemoryBlock, 65536);
                    BigInteger scrollToAddress = null;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(PlainTextImporter.this.fInputFile)));
                    BigInteger jobs = BigInteger.valueOf(PlainTextImporter.this.fInputFile.length());
                    BigInteger factor = BigInteger.ONE;
                    if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                        jobs = jobs.divide(factor);
                    }
                    monitor.beginTask(Messages.getString("Importer.ProgressTitle"), jobs.intValue());
                    BigInteger recordAddress = PlainTextImporter.this.fStartAddress;
                    String line = reader.readLine();
                    int lineNo = 1;
                    while (line != null && !monitor.isCanceled()) {
                        StringTokenizer st = new StringTokenizer(line, " ");
                        int bytesRead = 0;
                        while (st.hasMoreElements()) {
                            String valueString = (String)st.nextElement();
                            int position = 0;
                            byte[] data = new byte[valueString.length() / 2];
                            int i = 0;
                            while (i < data.length) {
                                try {
                                    data[i] = new BigInteger(valueString.substring(position++, position++ + 1), 16).byteValue();
                                }
                                catch (NumberFormatException ex) {
                                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, String.format(Messages.getString("PlainTextImporter.ErrInvalidFormat"), lineNo), (Throwable)ex);
                                }
                                ++i;
                            }
                            if (scrollToAddress == null) {
                                scrollToAddress = recordAddress;
                            }
                            BigInteger writeAddress = recordAddress.subtract(((IMemoryBlockExtension)PlainTextImporter.this.fMemoryBlock).getBigBaseAddress()).add(BigInteger.valueOf(bytesRead));
                            memoryWriter.write(writeAddress, data);
                            bytesRead += data.length;
                        }
                        recordAddress = recordAddress.add(BigInteger.valueOf(bytesRead));
                        BigInteger jobCount = BigInteger.valueOf(bytesRead).divide(factor);
                        monitor.worked(jobCount.intValue());
                        line = reader.readLine();
                        ++lineNo;
                    }
                    if (!monitor.isCanceled()) {
                        memoryWriter.flush();
                    }
                    reader.close();
                    monitor.done();
                    if (PlainTextImporter.this.fScrollToStart.booleanValue()) {
                        PlainTextImporter.this.fParentDialog.scrollRenderings(scrollToAddress);
                    }
                }
                catch (IOException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrReadFile"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrReadFile"), (Throwable)ex);
                }
                catch (DebugException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrWriteTarget"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Importer.ErrWriteTarget"), (Throwable)ex);
                }
                catch (Exception ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Importer.FalureImporting"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Importer.FalureImporting"), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

