/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.wsdl.validation.internal.ControllerValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;

public class ValidationInfoImpl
implements IValidationReport,
ControllerValidationInfo {
    private boolean WRAPPER_ERROR_SUPPORT_ENABLED = true;
    private final String _WARN_NO_VALDIATOR = "_WARN_NO_VALDIATOR";
    private final String _REF_FILE_ERROR_MESSAGE = "_REF_FILE_ERROR_MESSAGE";
    private String validating_file_uri = null;
    private URL validating_file_url = null;
    private boolean wsdlValid = false;
    private List messages = new Vector();
    private List nsNoVals = new Vector();
    private MessageGenerator messagegenerator = null;
    private boolean haserrors = false;
    private HashMap nestedMessages = new HashMap();
    private URIResolver uriResolver = null;
    private WSDLValidationConfiguration configuration;

    public ValidationInfoImpl(String uri, MessageGenerator messagegenerator) {
        this.validating_file_uri = uri;
        if (uri != null) {
            this.validating_file_uri = uri = uri.replaceAll("%20", " ");
            try {
                this.validating_file_url = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.messagegenerator = messagegenerator;
    }

    public String getFileURI() {
        return this.validating_file_uri;
    }

    public boolean isWSDLValid() {
        return this.wsdlValid;
    }

    public void addError(String message, int line, int column) {
        this.addError(message, line, column, this.validating_file_uri);
    }

    public void addError(String message, int line, int column, String uri) {
        if (this.addMessage(message, line, column, uri, 0)) {
            this.haserrors = true;
        }
    }

    public void addError(String message, int line, int column, String uri, String errorKey, Object[] messageArguments) {
        if (this.addMessage(message, line, column, uri, 0, errorKey, messageArguments)) {
            this.haserrors = true;
        }
    }

    public void addWarning(String message, int line, int column) {
        this.addWarning(message, line, column, this.validating_file_uri);
    }

    public void addWarning(String message, int line, int column, String uri) {
        this.addMessage(message, line, column, uri, 1);
    }

    private boolean addMessage(String message, int line, int column, String uri, int severity) {
        return this.addMessage(message, line, column, uri, severity, null, null);
    }

    private boolean addMessage(String message, int line, int column, String uri, int severity, String errorKey, Object[] messageArguments) {
        boolean successfullyAdded = false;
        if (message == null) {
            return successfullyAdded;
        }
        String errorURI = uri;
        URL errorURL = null;
        if (errorURI != null) {
            try {
                errorURI = errorURI.replaceAll("%20", " ");
                errorURL = new URL(errorURI);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (errorURL != null) {
            successfullyAdded = true;
            if (!this.WRAPPER_ERROR_SUPPORT_ENABLED || this.validating_file_url.sameFile(errorURL)) {
                ValidationMessageImpl valmes = new ValidationMessageImpl(message, line, column, severity, uri, errorKey, messageArguments);
                this.messages.add(valmes);
            } else if (this.WRAPPER_ERROR_SUPPORT_ENABLED) {
                String nesteduri = errorURL.toExternalForm();
                ValidationMessageImpl nestedmess = new ValidationMessageImpl(message, line, column, severity, nesteduri);
                ValidationMessageImpl container = (ValidationMessageImpl)this.nestedMessages.get(nesteduri);
                if (container == null) {
                    container = new ValidationMessageImpl(this.messagegenerator.getString("_REF_FILE_ERROR_MESSAGE", nesteduri), 1, 0, 1, nesteduri);
                    this.nestedMessages.put(nesteduri, container);
                    this.messages.add(container);
                }
                container.addNestedMessage(nestedmess);
            }
        }
        return successfullyAdded;
    }

    public IValidationMessage[] getValidationMessages() {
        return this.messages.toArray(new IValidationMessage[this.messages.size()]);
    }

    public void addNamespaceWithNoValidator(String namespace) {
        if (!this.nsNoVals.contains(namespace)) {
            this.nsNoVals.add(namespace);
            this.addWarning(this.messagegenerator.getString("_WARN_NO_VALDIATOR", namespace), 1, 0);
        }
    }

    public void completeWSDLValidation() {
        this.wsdlValid = !this.haserrors;
    }

    public boolean hasErrors() {
        return this.haserrors;
    }

    public HashMap getNestedMessages() {
        return this.nestedMessages;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public Object getAttribute(String name) {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getProperty(name);
    }

    public void setConfiguration(WSDLValidationConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isValid() {
        return !this.hasErrors();
    }
}

