/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.command;

import java.util.List;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryAbstractCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.PaletteInfo;
import org.xml.sax.Attributes;

public final class CategoryAddCommand
extends CategoryAbstractCommand {
    public static final String ID = "addCategory";
    private final String m_nextCategoryId;

    public CategoryAddCommand(String id, String name, String description, boolean visible, boolean open, String nextCategoryId) {
        super(id, name, description, visible, open);
        this.m_nextCategoryId = nextCategoryId;
    }

    public CategoryAddCommand(Attributes attributes) {
        super(attributes);
        this.m_nextCategoryId = attributes.getValue("nextCategory");
    }

    public void execute(PaletteInfo palette) {
        CategoryInfo category = new CategoryInfo();
        category.setId(this.m_id);
        this.updateElement(category);
        List<CategoryInfo> categories = palette.getCategories();
        CategoryInfo nextCategory = palette.getCategory(this.m_nextCategoryId);
        int index = categories.indexOf(nextCategory);
        if (index != -1) {
            categories.add(index, category);
        } else {
            categories.add(category);
        }
    }

    protected void addAttributes() {
        super.addAttributes();
        this.addAttribute("nextCategory", this.m_nextCategoryId);
    }
}

