/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.listener.NotificationReceiver;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.AppliedCompositeFilters;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.properties.PropertiesService;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;

public class VisibilityUpdater
extends ResourceSetListenerImpl {
    private boolean needsRefresh;
    private VisibilityNotificationReceiver notificationReceiver;
    private DDiagram dDiagram;

    public VisibilityUpdater(TransactionalEditingDomain domain, DDiagram dDiagram) {
        super(NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters())));
        this.dDiagram = dDiagram;
        this.notificationReceiver = new VisibilityNotificationReceiver();
        domain.addResourceSetListener((ResourceSetListener)this);
        dDiagram.eAdapters().add((Object)this.notificationReceiver);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        UpdateVisibilityCommand cmd = null;
        Collection<DDiagramElement> elementsToRefresh = this.extractElementToRefresh(event);
        if (!elementsToRefresh.isEmpty()) {
            cmd = new UpdateVisibilityCommand(this.getTarget(), this.dDiagram, elementsToRefresh);
        }
        return cmd;
    }

    private Collection<DDiagramElement> extractElementToRefresh(ResourceSetChangeEvent event) {
        boolean filtersRefresh = this.isAutoRefresh() || this.needsRefresh;
        this.needsRefresh = false;
        HashSet<DDiagramElement> elementsToRefresh = new HashSet<DDiagramElement>();
        for (Notification notif : event.getNotifications()) {
            DDiagramElement dDiagramElement;
            DDiagram parentDDiagram;
            Object notifier = notif.getNotifier();
            if (!(notifier instanceof DDiagramElement) || (parentDDiagram = (dDiagramElement = (DDiagramElement)notifier).getParentDiagram()) == null || !parentDDiagram.equals(this.dDiagram) || !this.checkValues(filtersRefresh, notif.getNewValue(), notif.getOldValue())) continue;
            elementsToRefresh.add(dDiagramElement);
        }
        return elementsToRefresh;
    }

    private boolean checkValues(boolean filtersRefresh, Object newValue, Object oldValue) {
        boolean checked = false;
        if (!(newValue instanceof AbsoluteBoundsFilter) && !(oldValue instanceof AbsoluteBoundsFilter)) {
            checked = this.checkValue(filtersRefresh, newValue) || this.checkValue(filtersRefresh, oldValue);
        }
        return checked;
    }

    private boolean checkValue(boolean filtersRefresh, Object value) {
        return filtersRefresh || value instanceof GraphicalFilter && !(value instanceof AppliedCompositeFilters) && !(value instanceof CollapseFilter);
    }

    private boolean isAutoRefresh() {
        boolean autoRefresh = false;
        try {
            autoRefresh = PropertiesService.getInstance().getPropertiesProvider().getProperty(1);
        }
        catch (IllegalArgumentException e) {
            DiagramPlugin.getDefault().logError(e.getMessage());
        }
        return autoRefresh;
    }

    public void dispose() {
        this.dDiagram.eAdapters().remove((Object)this.notificationReceiver);
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.dDiagram = null;
    }

    private static class UpdateVisibilityCommand
    extends RecordingCommand {
        private DDiagram diagram;
        private Collection<DDiagramElement> elementsToRefresh;

        public UpdateVisibilityCommand(TransactionalEditingDomain domain, DDiagram diagram, Collection<DDiagramElement> elementsToRefresh) {
            super(domain, Messages.UpdateVisibilityCommand_label);
            this.diagram = diagram;
            this.elementsToRefresh = elementsToRefresh;
        }

        protected void doExecute() {
            NotificationUtil.sendNotification((EObject)this.diagram, (int)0, (int)2);
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.REFRESH_VISIBILITY_KEY);
            Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)this.diagram).getTarget());
            DisplayServiceManager.INSTANCE.getDisplayService().activateCache();
            DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, this.diagram);
            for (DDiagramElement element : this.elementsToRefresh) {
                element.setVisible(DisplayServiceManager.INSTANCE.getDisplayService().computeVisibility(mappingManager, this.diagram, element));
            }
            DisplayServiceManager.INSTANCE.getDisplayService().deactivateCache();
            NotificationUtil.sendNotification((EObject)this.diagram, (int)1, (int)2);
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.REFRESH_VISIBILITY_KEY);
        }
    }

    private class VisibilityNotificationReceiver
    implements NotificationReceiver,
    Adapter {
        private Notifier target;

        private VisibilityNotificationReceiver() {
        }

        public void receive(int kind, int notification) {
            block0 : switch (notification) {
                case 5: {
                    switch (kind) {
                        case 0: {
                            VisibilityUpdater.this.needsRefresh = true;
                            break block0;
                        }
                        case 1: {
                            VisibilityUpdater.this.needsRefresh = false;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        public Notifier getTarget() {
            return this.target;
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof DDiagram;
        }

        public void notifyChanged(Notification notification) {
        }

        public void setTarget(Notifier newTarget) {
            this.target = newTarget;
        }
    }
}

