/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.views.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.log.LogMessage;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.menu.WorkbenchPartMenuItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.views.log.SharedImages;
import org.hamcrest.Matcher;

public class LogView
extends WorkbenchView {
    private final String DELETE_LOG = "Delete Log";
    private final String CLEAR_LOG = "Clear Log Viewer";
    private final String RESTORE_LOG = "Restore Log";
    private final String CONFIRM_DLG = "Confirm Delete";

    public LogView() {
        super("Error Log");
    }

    public List<LogMessage> getOKMessages() {
        return this.getMessages(Severity.OK);
    }

    public List<LogMessage> getInfoMessages() {
        return this.getMessages(Severity.INFO);
    }

    public List<LogMessage> getWarningMessages() {
        return this.getMessages(Severity.WARNING);
    }

    public List<LogMessage> getErrorMessages() {
        return this.getMessages(Severity.ERROR);
    }

    public void clearLog() {
        this.activate();
        this.getViewTree();
        ContextMenuItem cm = new ContextMenuItem(new String[]{"Clear Log Viewer"});
        cm.select();
    }

    public void deleteLog() {
        this.activate();
        this.getViewTree();
        ContextMenuItem cm = new ContextMenuItem(new String[]{"Delete Log"});
        if (!cm.isEnabled()) {
            log.debug("Unable to delete log. \"Delete Log\" menu item is not enabled.");
            return;
        }
        cm.select();
        DefaultShell configDialog = new DefaultShell("Confirm Delete");
        WidgetIsFound openButton = new WidgetIsFound(Button.class, new Matcher[]{new WithMnemonicTextMatcher("Delete All Events")});
        Object button = openButton.test() ? new PushButton("Delete All Events") : new OkButton();
        button.click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)configDialog));
    }

    public void restoreLog() {
        this.activate();
        this.getViewTree();
        ContextMenuItem cm = new ContextMenuItem(new String[]{"Restore Log"});
        cm.select();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Progress Information"), TimePeriod.SHORT, false);
        new WaitWhile((WaitCondition)new ShellIsAvailable("Progress Information"));
    }

    public void setActivateOnNewEvents(boolean value) {
        this.activate();
        WorkbenchPartMenuItem menu = new WorkbenchPartMenuItem(new String[]{"Activate on new events"});
        if (value && !menu.isSelected() || !value && menu.isSelected()) {
            menu.select();
        }
    }

    private org.eclipse.reddeer.swt.api.Tree getViewTree() {
        return new DefaultTree((ReferencedComposite)this);
    }

    private List<LogMessage> getMessages(Severity severity) {
        this.activate();
        WidgetIsFound isTreeFound = new WidgetIsFound(Tree.class, (Control)this.cTabItem.getFolder().getSWTWidget(), new Matcher[0]);
        new WaitUntil((WaitCondition)isTreeFound, TimePeriod.SHORT, false);
        Widget tree = isTreeFound.getResult();
        return tree != null ? this.getMessagesFromTree(tree, severity) : new ArrayList();
    }

    private List<LogMessage> getMessagesFromTree(Widget widget, Severity severity) {
        DefaultTree tree = new DefaultTree((Tree)widget);
        ArrayList<LogMessage> messages = new ArrayList<LogMessage>();
        for (TreeItem item : tree.getItems()) {
            if (!this.severityMatch(item, severity)) continue;
            messages.add(new LogMessage(item, severity.getIStatus()));
        }
        return messages;
    }

    private boolean severityMatch(TreeItem item, Severity severity) {
        Image itemImage = item.getImage();
        return severity.getImages().contains(itemImage);
    }

    private static enum Severity {
        OK(0, SharedImages.getImage((String)"icons/obj16/ok_st_obj.png")),
        INFO(1, SharedImages.getImage((String)"icons/obj16/info_st_obj.png")),
        WARNING(2, SharedImages.getImage((String)"icons/obj16/warning_st_obj.png")),
        ERROR(4, SharedImages.getImage((String)"icons/obj16/error_st_obj.png"), SharedImages.getImage((String)"icons/obj16/error_stack.png"));

        private List<Image> images;
        private int iStatus;

        private Severity(int iStatus, Image ... image) {
            this.images = Arrays.asList(image);
            this.iStatus = iStatus;
        }

        public List<Image> getImages() {
            return this.images;
        }

        public int getIStatus() {
            return this.iStatus;
        }
    }
}

