/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.DurationLinkUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.GeneralOrderingUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationUtil;

public class OccurenceSemanticEditPolicy
extends DefaultSemanticEditPolicy {
    public Command getCommand(Request request) {
        if ("Reconnection source".equals(request.getType()) && this.relationshipSourceHasChanged((ReconnectRequest)request)) {
            ConnectionEditPart connectionEP = ((ReconnectRequest)request).getConnectionEditPart();
            if (ViewUtil.resolveSemanticElement((View)((View)connectionEP.getModel())) == null) {
                return this.getReorientRefRelationshipSourceCommand((ReconnectRequest)request);
            }
            return this.getReorientRelationshipSourceCommand((ReconnectRequest)request);
        }
        if ("Reconnection target".equals(request.getType()) && this.relationshipTargetHasChanged((ReconnectRequest)request)) {
            ConnectionEditPart connectionEP = ((ReconnectRequest)request).getConnectionEditPart();
            if (ViewUtil.resolveSemanticElement((View)((View)connectionEP.getModel())) == null) {
                return this.getReorientRefRelationshipTargetCommand((ReconnectRequest)request);
            }
            return this.getReorientRelationshipTargetCommand((ReconnectRequest)request);
        }
        return super.getCommand(request);
    }

    protected boolean relationshipSourceHasChanged(ReconnectRequest request) {
        if (!request.getConnectionEditPart().getSource().equals(request.getTarget())) {
            return true;
        }
        if (request.getConnectionEditPart().getModel() instanceof Edge) {
            Edge edge = (Edge)request.getConnectionEditPart().getModel();
            return OccurrenceSpecificationUtil.getSourceOccurrence(edge) != OccurrenceSpecificationUtil.getOccurrence(request);
        }
        return false;
    }

    protected boolean relationshipTargetHasChanged(ReconnectRequest request) {
        if (!request.getConnectionEditPart().getTarget().equals(request.getTarget())) {
            return true;
        }
        if (request.getConnectionEditPart().getModel() instanceof Edge) {
            Edge edge = (Edge)request.getConnectionEditPart().getModel();
            return OccurrenceSpecificationUtil.getTargetOccurrence(edge) != OccurrenceSpecificationUtil.getOccurrence(request);
        }
        return false;
    }

    protected Command getReorientRelationshipSourceCommand(ReconnectRequest request) {
        if (GeneralOrderingUtil.isGeneralOrderingLink(request) || DurationLinkUtil.isDurationLink(request)) {
            EObject connectionSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getConnectionEditPart().getModel()));
            EObject targetSemElement = OccurrenceSpecificationUtil.getOccurrence(request);
            EObject oldSemElement = OccurrenceSpecificationUtil.getSourceOccurrence((Edge)request.getConnectionEditPart().getModel());
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            ReorientRelationshipRequest semRequest = new ReorientRelationshipRequest(editingDomain, connectionSemElement, targetSemElement, oldSemElement, 1);
            semRequest.addParameters(request.getExtendedData());
            return this.getSemanticCommand((IEditCommandRequest)semRequest);
        }
        return super.getReorientRefRelationshipSourceCommand(request);
    }

    protected Command getReorientRelationshipTargetCommand(ReconnectRequest request) {
        if (GeneralOrderingUtil.isGeneralOrderingLink(request) || DurationLinkUtil.isDurationLink(request)) {
            EObject connectionSemElement = ViewUtil.resolveSemanticElement((View)((View)request.getConnectionEditPart().getModel()));
            EObject targetSemElement = OccurrenceSpecificationUtil.getOccurrence(request);
            EObject oldSemElement = OccurrenceSpecificationUtil.getTargetOccurrence((Edge)request.getConnectionEditPart().getModel());
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            ReorientRelationshipRequest semRequest = new ReorientRelationshipRequest(editingDomain, connectionSemElement, targetSemElement, oldSemElement, 2);
            semRequest.addParameters(request.getExtendedData());
            return this.getSemanticCommand((IEditCommandRequest)semRequest);
        }
        return super.getReorientRelationshipTargetCommand(request);
    }
}

