/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;

public class LineDecorator
extends Figure {
    private int myLineWidth = 2;
    private boolean horizontalNotVertical = true;
    private int myLineStyle = 0;

    public void setLineWidth(int lineWidth) {
        this.myLineWidth = lineWidth;
    }

    public void setHorizontal(boolean value) {
        this.horizontalNotVertical = value;
    }

    public void setLineStyle(int lineStyle) {
        this.myLineStyle = lineStyle;
    }

    public void paint(Graphics graphics) {
        Point end;
        Point start;
        graphics.pushState();
        graphics.setLineWidth(this.myLineWidth);
        if (this.horizontalNotVertical) {
            int y = (this.bounds.getTopLeft().y + this.bounds.getBottomRight().y) / 2;
            start = new Point(this.bounds.getTopLeft().x, y);
            end = new Point(this.bounds.getBottomRight().x, y);
        } else {
            int x = (this.bounds.getTopLeft().x + this.bounds.getBottomRight().x) / 2;
            start = new Point(x, this.bounds.getTopLeft().y);
            end = new Point(x, this.bounds.getBottomRight().y);
        }
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setLineStyle(this.myLineStyle);
        graphics.drawLine(start, end);
        graphics.popState();
    }

    public int getLineWidth() {
        return this.myLineWidth;
    }
}

