/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.Activator;

public class SemanticElementHelper {
    public static EObject findSemanticElement(EObject notationElement) {
        if (notationElement == null) {
            return null;
        }
        if (notationElement instanceof Diagram) {
            return notationElement;
        }
        if (notationElement instanceof View) {
            View view = (View)notationElement;
            EObject semanticElement = view.getElement();
            if (semanticElement != null) {
                return semanticElement;
            }
            return view;
        }
        EObject currentElement = notationElement.eContainer();
        do {
            if (!(currentElement instanceof View)) continue;
            return SemanticElementHelper.findSemanticElement(currentElement);
        } while ((currentElement = currentElement.eContainer()) != null);
        Activator.log.warn("Cannot find a valid source for " + notationElement);
        return notationElement;
    }

    public static View findPrimaryView(EObject notationElement) {
        return SemanticElementHelper.findTopView(notationElement);
    }

    public static View findTopView(EObject notationElement) {
        EObject semanticElement = SemanticElementHelper.findSemanticElement(notationElement);
        if (semanticElement == notationElement) {
            return (View)notationElement;
        }
        EObject lastNotationElement = notationElement;
        while (notationElement != null) {
            if (SemanticElementHelper.findSemanticElement(notationElement = notationElement.eContainer()) != semanticElement) {
                return (View)lastNotationElement;
            }
            if (notationElement == null) continue;
            lastNotationElement = notationElement;
        }
        return (View)lastNotationElement;
    }
}

