/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.MessageUtil;

public class FieldArrayCollectionExtractor
implements ICollectionExtractor {
    protected final String arrayField;

    public FieldArrayCollectionExtractor(String arrayField) {
        if (arrayField == null) {
            throw new IllegalArgumentException();
        }
        this.arrayField = arrayField;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        return this.getNumberOfNotNullElements(coll);
    }

    public boolean hasCapacity() {
        return true;
    }

    public Integer getCapacity(IObject coll) throws SnapshotException {
        IObjectArray arrayObject = this.extractEntries(coll);
        if (arrayObject == null) {
            return null;
        }
        return arrayObject.getLength();
    }

    public boolean hasFillRatio() {
        return true;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        Integer size = this.getNumberOfNotNullElements(coll);
        Integer cap = this.getCapacity(coll);
        if (size != null && cap != null) {
            double sz = size.doubleValue();
            double cp = cap.doubleValue();
            if (sz == 0.0 && cp == 0.0) {
                return 1.0;
            }
            return sz / cp;
        }
        return null;
    }

    public boolean hasExtractableContents() {
        return this.hasExtractableArray();
    }

    public boolean hasExtractableArray() {
        return true;
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        return ExtractionUtils.referenceArrayToIds(coll.getSnapshot(), this.extractEntries(coll).getReferenceArray());
    }

    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        Object obj = coll.resolveValue(this.arrayField);
        if (obj instanceof IObjectArray) {
            return (IObjectArray)obj;
        }
        if (obj != null) {
            String desc = obj instanceof IObject ? ((IObject)obj).getTechnicalName() : obj.toString();
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), desc});
            throw new SnapshotException(msg);
        }
        IObject next = ExtractionUtils.followOnlyOutgoingReferencesExceptLast(this.arrayField, coll);
        if (next == null) {
            return null;
        }
        return ExtractionUtils.getOnlyArrayField(next);
    }

    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        IObjectArray arrayObject = this.extractEntries(coll);
        if (arrayObject == null) {
            return null;
        }
        return ExtractionUtils.getNumberOfNotNullArrayElements(arrayObject);
    }
}

