/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.formatters;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.linuxtools.changelog.core.IFormatterChangeLogContrib;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.editors.ChangeLogEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class GNUFormat
implements IFormatterChangeLogContrib {
    final String line_sep = System.getProperty("line.separator");
    static final String TAB = "\t";

    @Override
    public String formatDateLine(String authorName, String authorEmail) {
        String detail = String.valueOf(this.returnDate()) + "  " + authorName + "  " + "<" + authorEmail + ">" + this.line_sep + this.line_sep;
        return detail;
    }

    @Override
    public String mergeChangelog(String dateLine, String functionGuess, String defaultContent, IEditorPart changelog, String changeLogLocation, String fileLocation) {
        String fileDetail = this.formatFileDetail(changeLogLocation, fileLocation);
        IDocument changelog_doc = this.getDocument(changelog);
        String function = this.formatFunction(functionGuess);
        boolean multipleEntrySuccess = false;
        boolean forceNewEntry = false;
        String functionSpacer = " ";
        if (function.equals(": ")) {
            functionSpacer = "";
        }
        if (changelog instanceof ChangeLogEditor) {
            ChangeLogEditor editor = (ChangeLogEditor)changelog;
            forceNewEntry = editor.isForceNewLogEntry();
            editor.setForceNewLogEntry(false);
        }
        if (changelog_doc.getLength() > 0) {
            int offset_start = this.findChangeLogEntry(changelog_doc, dateLine);
            int offset_end = dateLine.length();
            boolean foundFunction = false;
            if (forceNewEntry) {
                offset_start = -1;
            }
            if (offset_start != -1) {
                int nextChangeEntry = this.findChangeLogPattern(changelog_doc, offset_start + dateLine.length());
                int functLogEntry = offset_start + dateLine.length();
                int numLines = changelog_doc.getNumberOfLines();
                while (functLogEntry < nextChangeEntry) {
                    int lineNum = 0;
                    String entry = "";
                    try {
                        lineNum = changelog_doc.getLineOfOffset(functLogEntry);
                        entry = changelog_doc.get(functLogEntry, changelog_doc.getLineLength(lineNum));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    int entryStart = entry.indexOf("* " + fileDetail);
                    if (entryStart >= 0) {
                        foundFunction = true;
                    } else if (foundFunction && this.isFileLine(entry)) {
                        --functLogEntry;
                        break;
                    }
                    if (foundFunction) {
                        foundFunction = true;
                        if (defaultContent.length() > 0 && entry.lastIndexOf(defaultContent) > 0) {
                            return "";
                        }
                        int nextFunctLoc = entryStart > 0 ? functLogEntry + entryStart + fileDetail.length() + 2 : functLogEntry;
                        String nextFunc = "";
                        try {
                            int lineEnd = lineNum < numLines - 1 ? changelog_doc.getLineOffset(lineNum + 1) - 1 : changelog_doc.getLength();
                            nextFunc = changelog_doc.get(nextFunctLoc, lineEnd - nextFunctLoc);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (nextFunc.trim().startsWith(function)) {
                            return "";
                        }
                    }
                    try {
                        functLogEntry += changelog_doc.getLineLength(lineNum);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (functLogEntry >= nextChangeEntry) {
                    functLogEntry = nextChangeEntry - 1;
                    try {
                        functLogEntry = this.removeWhitespaceOnlyLines(changelog_doc, functLogEntry);
                        while (changelog_doc.get(functLogEntry, 1).equals("\n")) {
                            --functLogEntry;
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    ++functLogEntry;
                }
                if (offset_start != -1) {
                    if (foundFunction) {
                        try {
                            if (!function.equals(": ")) {
                                changelog_doc.replace(functLogEntry, 0, "\n\t" + function + " ");
                            } else {
                                changelog_doc.replace(functLogEntry, 0, "\n\t");
                            }
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        ITextEditor edit = (ITextEditor)changelog;
                        if (!function.equals(": ")) {
                            edit.selectAndReveal(functLogEntry + function.length() + 3, 0);
                        } else {
                            edit.selectAndReveal(functLogEntry + function.length(), 0);
                        }
                        multipleEntrySuccess = true;
                    } else {
                        try {
                            changelog_doc.replace(offset_end, 0, "\t* " + fileDetail + functionSpacer + function + functionSpacer + defaultContent + "\n");
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        ITextEditor edit = (ITextEditor)changelog;
                        edit.selectAndReveal(offset_end + fileDetail.length() + function.length() + functionSpacer.length() * 2 + 3 + defaultContent.length(), 0);
                        multipleEntrySuccess = true;
                    }
                }
            }
        }
        if (!multipleEntrySuccess) {
            try {
                if (changelog_doc.getLength() > 0) {
                    changelog_doc.replace(0, 0, "\n\n");
                }
                changelog_doc.replace(0, 0, String.valueOf(dateLine) + TAB + "* " + fileDetail + functionSpacer + function + functionSpacer + defaultContent);
                ITextEditor edit = (ITextEditor)changelog;
                edit.selectAndReveal(dateLine.length() + fileDetail.length() + function.length() + functionSpacer.length() * 2 + 3 + defaultContent.length(), 0);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private boolean isFileLine(String entry) {
        return Pattern.matches("\\s*\\* \\S+:.*", entry.trim());
    }

    /*
     * Unable to fully structure code
     */
    private int removeWhitespaceOnlyLines(IDocument changelogDoc, int offset) {
        initialOffset = offset;
        backedUpOffset = offset;
        try {
            charAtOffset = changelogDoc.get(offset, 1).charAt(0);
            if (true) ** GOTO lbl17
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return offset;
        }
        do {
            --backedUpOffset;
            try {
                charAtOffset = changelogDoc.get(backedUpOffset, 1).charAt(0);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                break;
            }
lbl17:
            // 2 sources

        } while (backedUpOffset > 0 && (charAtOffset == '\n' || charAtOffset == '\t' || charAtOffset == ' '));
        if (initialOffset - backedUpOffset > 2) {
            try {
                replaceLength = initialOffset - backedUpOffset - 2;
                changelogDoc.replace(backedUpOffset + 2, replaceLength, "");
                offset -= replaceLength;
            }
            catch (BadLocationException var6_9) {
                // empty catch block
            }
        }
        return offset;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String formatFileDetail(String changeLogLocation, String editorFileLocation) {
        IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
        String WorkspaceRoot = myWorkspaceRoot.getLocation().toOSString();
        String changeLogLocNoRoot = "";
        String editorFileLocNoRoot = "";
        changeLogLocNoRoot = changeLogLocation.lastIndexOf(WorkspaceRoot) >= 0 ? changeLogLocation.substring(changeLogLocation.lastIndexOf(WorkspaceRoot) + WorkspaceRoot.length(), changeLogLocation.length()) : changeLogLocation;
        editorFileLocNoRoot = editorFileLocation.lastIndexOf(WorkspaceRoot) >= 0 ? editorFileLocation.substring(editorFileLocation.lastIndexOf(WorkspaceRoot), editorFileLocation.lastIndexOf(WorkspaceRoot) + WorkspaceRoot.length()) : editorFileLocation;
        File changelogLocation = new File(changeLogLocNoRoot);
        File fileLocation = new File(editorFileLocNoRoot);
        File reversePath = fileLocation.getParentFile();
        String reversePathb = "";
        while (reversePath.getParentFile() != null) {
            if (reversePath.compareTo(changelogLocation.getParentFile()) == 0) break;
            reversePath = reversePath.getParentFile();
        }
        if (reversePath != null) {
            reversePathb = fileLocation.toString().substring(reversePath.toString().length() + 1, fileLocation.toString().length());
        }
        return reversePathb;
    }

    private int findChangeLogPattern(IDocument changelogDoc, int startOffset) {
        int nextEntry = startOffset;
        int lineNum = 0;
        String entry = "";
        while (nextEntry < changelogDoc.getLength()) {
            try {
                lineNum = changelogDoc.getLineOfOffset(nextEntry);
                entry = changelogDoc.get(nextEntry, changelogDoc.getLineLength(lineNum));
                if (this.matchDatePattern(entry)) break;
                nextEntry += changelogDoc.getLineLength(lineNum);
            }
            catch (BadLocationException e) {
                ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            }
        }
        return nextEntry;
    }

    private boolean matchDatePattern(String text) {
        SimpleDateFormat isoDate = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date ad = isoDate.parse(text);
            if (ad != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    private int findChangeLogEntry(IDocument changelogDoc, String entry) {
        FindReplaceDocumentAdapter findDocumentAptd = new FindReplaceDocumentAdapter(changelogDoc);
        IRegion region = null;
        try {
            region = findDocumentAptd.find(0, entry, true, false, false, true);
        }
        catch (BadLocationException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            return -1;
        }
        if (region != null) {
            return region.getOffset() > 0 ? -1 : 0;
        }
        return -1;
    }

    private String formatFunction(String function) {
        if (function.length() > 0) {
            return "(" + function + "):";
        }
        return ": ";
    }

    public IDocument getDocument(IEditorPart currentEditor) {
        AbstractTextEditor castEditor = (AbstractTextEditor)currentEditor;
        IDocumentProvider provider = castEditor.getDocumentProvider();
        return provider.getDocument((Object)castEditor.getEditorInput());
    }

    private String returnDate() {
        SimpleDateFormat date_Format = new SimpleDateFormat("yyyy-MM-dd");
        return date_Format.format(new Date());
    }
}

