/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.hover;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;

public class DotHoverProvider
extends DefaultEObjectHoverProvider {
    protected String getHoverInfoAsHtml(EObject o) {
        block19: {
            if (!(o instanceof Attribute)) break block19;
            Attribute attribute = (Attribute)o;
            String attributeName = attribute.getName().toValue();
            ID attributeValue = attribute.getValue();
            if (attributeValue == null) break block19;
            switch (attributeName) {
                case "fontcolor": 
                case "fillcolor": 
                case "bgcolor": 
                case "color": 
                case "labelfontcolor": {
                    Color color = this.parse(attributeValue.toString());
                    String colorScheme = null;
                    String colorName = null;
                    String colorCode = null;
                    if (color instanceof StringColor) {
                        StringColor stringColor = (StringColor)color;
                        colorScheme = stringColor.getScheme();
                        if (colorScheme == null) {
                            colorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)attribute);
                        }
                        if (colorScheme == null) {
                            colorScheme = "x11";
                        }
                        colorName = stringColor.getName();
                        colorCode = DotColors.get((String)colorScheme, (String)colorName);
                    }
                    if (color instanceof RGBColor) {
                        colorCode = attributeValue.toValue();
                    }
                    boolean cfr_ignored_0 = color instanceof HSVColor;
                    return DotColors.getColorDescription((String)colorScheme, colorName, (String)colorCode);
                }
            }
        }
        return super.getHoverInfoAsHtml(o);
    }

    private Color parse(String attributeValue) {
        Injector dotColorInjector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotColor");
        IParser parser = (IParser)dotColorInjector.getInstance(IParser.class);
        IParseResult result = parser.parse((Reader)new StringReader(attributeValue));
        return (Color)result.getRootASTElement();
    }
}

