/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.ui.provider;

import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.internal.EMFTransactionUIPlugin;
import org.eclipse.emf.transaction.ui.internal.Tracing;
import org.eclipse.emf.transaction.ui.internal.l10n.Messages;
import org.eclipse.emf.transaction.ui.provider.TransactionalPropertySource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    private final TransactionalEditingDomain domain;

    public TransactionalAdapterFactoryContentProvider(TransactionalEditingDomain domain, AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.domain = domain;
    }

    protected <T> T run(RunnableWithResult<? extends T> run) {
        try {
            return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)this.domain, run);
        }
        catch (InterruptedException e) {
            Tracing.catching(TransactionalAdapterFactoryContentProvider.class, "run", e);
            Thread.currentThread().interrupt();
            EMFTransactionUIPlugin.INSTANCE.log(new Status(4, EMFTransactionUIPlugin.getPluginId(), 20, Messages.contentInterrupt, (Throwable)e));
            return null;
        }
    }

    protected IPropertySource createPropertySource(final Object object, final IItemPropertySource itemPropertySource) {
        return this.wrap((IPropertySource)this.run((RunnableWithResult)new RunnableWithResult.Impl<IPropertySource>(){

            public void run() {
                this.setResult(TransactionalAdapterFactoryContentProvider.super.createPropertySource(object, itemPropertySource));
            }
        }));
    }

    public Object[] getChildren(final Object object) {
        return (Object[])this.run((RunnableWithResult)new RunnableWithResult.Impl<Object[]>(){

            public void run() {
                this.setResult(TransactionalAdapterFactoryContentProvider.super.getChildren(object));
            }
        });
    }

    public Object[] getElements(final Object object) {
        return (Object[])this.run((RunnableWithResult)new RunnableWithResult.Impl<Object[]>(){

            public void run() {
                this.setResult(TransactionalAdapterFactoryContentProvider.super.getElements(object));
            }
        });
    }

    public Object getParent(final Object object) {
        return this.run((RunnableWithResult)new RunnableWithResult.Impl<Object>(){

            public void run() {
                this.setResult(TransactionalAdapterFactoryContentProvider.super.getParent(object));
            }
        });
    }

    public IPropertySource getPropertySource(final Object object) {
        return this.wrap((IPropertySource)this.run((RunnableWithResult)new RunnableWithResult.Impl<IPropertySource>(){

            public void run() {
                this.setResult(TransactionalAdapterFactoryContentProvider.super.getPropertySource(object));
            }
        }));
    }

    public boolean hasChildren(final Object object) {
        return (Boolean)this.run((RunnableWithResult)new RunnableWithResult.Impl<Boolean>(){

            public void run() {
                this.setResult(TransactionalAdapterFactoryContentProvider.super.hasChildren(object));
            }
        });
    }

    public void inputChanged(final Viewer vwr, final Object oldInput, final Object newInput) {
        this.run((RunnableWithResult)new RunnableWithResult.Impl<Object>(){

            public void run() {
                TransactionalAdapterFactoryContentProvider.super.inputChanged(vwr, oldInput, newInput);
            }
        });
    }

    protected IPropertySource wrap(IPropertySource propertySource) {
        return propertySource == null ? null : new TransactionalPropertySource(this.domain, propertySource);
    }
}

