/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.admin.CDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.server.spi.admin.CDOAdminHandler;
import org.eclipse.emf.cdo.server.spi.admin.CDOAdminHandler2;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCDOAdminHandler
implements CDOAdminHandler2,
IManagedContainer.ContainerAware {
    private final String type;
    private IManagedContainer container = IPluginContainer.INSTANCE;
    private CDORepositoryConfigurationManager configurationManager;

    public DefaultCDOAdminHandler(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public IManagedContainer getManagedContainer() {
        return this.container;
    }

    public void setManagedContainer(IManagedContainer container) {
        this.container = container;
    }

    @Override
    public IRepository createRepository(String name, Map<String, Object> properties) {
        CDORepositoryConfigurationManager configManager = this.requireConfigurationManager();
        try {
            Document configDocument = this.getConfiguration(name, properties);
            IRepository result = configManager.addRepository(name, configDocument);
            LifecycleUtil.activate((Object)result);
            OM.LOG.info("Repository created: " + name);
            return result;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WrappedException("Failed to add repository.", ex);
        }
    }

    @Override
    public void deleteRepository(IRepository delegate) {
        CDORepositoryConfigurationManager configManager = this.requireConfigurationManager();
        configManager.removeRepository(delegate);
        OM.LOG.info("Repository deleted: " + delegate.getName());
    }

    @Override
    public boolean canDelete(IRepository delegate) {
        CDORepositoryConfigurationManager configManager = this.getConfigurationManager();
        return configManager != null && configManager.canRemoveRepository(delegate);
    }

    @Override
    public void authenticateAdministrator() throws SecurityException {
        CDORepositoryConfigurationManager configManager = this.requireConfigurationManager();
        configManager.authenticateAdministrator();
    }

    protected CDORepositoryConfigurationManager getConfigurationManager() {
        if (this.configurationManager == null) {
            IManagedContainer container = this.requireContainer();
            if (container == null) {
                throw new IllegalStateException("No container.");
            }
            Object[] available = container.getElements("org.eclipse.emf.cdo.server.admin.repositoryConfigurationManagers");
            if (available.length > 0) {
                this.configurationManager = (CDORepositoryConfigurationManager)available[0];
                this.configurationManager.addListener((IListener)new LifecycleEventAdapter(){

                    protected void onDeactivated(ILifecycle lifecycle) {
                        DefaultCDOAdminHandler.this.configurationManager = null;
                        lifecycle.removeListener((IListener)this);
                    }
                });
            }
        }
        return this.configurationManager;
    }

    protected IManagedContainer requireContainer() {
        IManagedContainer result = this.getManagedContainer();
        if (result == null) {
            throw new IllegalStateException("No container.");
        }
        return result;
    }

    protected CDORepositoryConfigurationManager requireConfigurationManager() {
        CDORepositoryConfigurationManager result = this.getConfigurationManager();
        if (result == null) {
            throw new SecurityException("Remote administration of repositories requires a repository configuration manager.");
        }
        return result;
    }

    protected Document getConfiguration(String name, Map<String, Object> properties) throws Exception {
        Node adopted;
        properties = new HashMap<String, Object>(properties);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        boolean hasSecurityManager = Boolean.TRUE.equals(properties.remove("configureSecurityManager"));
        boolean hasHomeFolders = Boolean.TRUE.equals(properties.remove("configureSecurityHomeFolders"));
        Element storeConfig = this.parseStoreConfig(docBuilder, properties);
        Document result = docBuilder.newDocument();
        Element repository = result.createElement("repository");
        repository.setAttribute("name", name);
        result.appendChild(repository);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Element property = result.createElement("property");
            property.setAttribute("name", entry.getKey());
            property.setAttribute("value", this.stringValue(entry.getValue()));
            repository.appendChild(property);
        }
        if (hasSecurityManager) {
            this.configureSecurity(result, repository, hasHomeFolders);
        }
        if ((adopted = result.adoptNode(storeConfig)) == null) {
            adopted = result.importNode(storeConfig, true);
        }
        repository.appendChild(adopted);
        return result;
    }

    protected String stringValue(Object object) {
        return object == null ? "" : object.toString();
    }

    protected void configureSecurity(Document configuration, Element repository, boolean hasHomeFolders) {
        String realmPath = "/security";
        if (hasHomeFolders) {
            realmPath = String.valueOf(realmPath) + ":annotation:home(/home)";
        }
        Element securityManager = configuration.createElement("securityManager");
        securityManager.setAttribute("type", "default");
        securityManager.setAttribute("description", realmPath);
        repository.appendChild(securityManager);
    }

    protected Element parseStoreConfig(DocumentBuilder documentBuilder, Map<String, Object> properties) {
        String storeConfigText = this.stringValue(properties.remove("storeXMLConfig"));
        try {
            Document document = documentBuilder.parse(new InputSource(new StringReader(storeConfigText)));
            return document.getDocumentElement();
        }
        catch (IOException ex) {
            throw new WrappedException("I/O exception in parsing in-memory XML string", (Exception)ex);
        }
        catch (SAXException ex) {
            throw new IllegalArgumentException("Invalid XML store configuration.", ex);
        }
    }

    public static final class Factory
    extends CDOAdminHandler.Factory {
        public static final String TYPE = "default";

        public Factory() {
            super(TYPE);
        }

        public CDOAdminHandler create(String description) throws ProductCreationException {
            return new DefaultCDOAdminHandler(TYPE);
        }
    }
}

