/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.UpdateStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UpdateSetStrategy<S, D>
extends UpdateStrategy<S, D> {
    public static final int POLICY_NEVER = UpdateSetStrategy.notInlined(1);
    public static final int POLICY_ON_REQUEST = UpdateSetStrategy.notInlined(2);
    public static final int POLICY_UPDATE = UpdateSetStrategy.notInlined(8);
    private int updatePolicy;
    protected boolean provideDefaults;

    private static int notInlined(int i) {
        return i;
    }

    public UpdateSetStrategy() {
        this(true, POLICY_UPDATE);
    }

    public UpdateSetStrategy(int updatePolicy) {
        this(true, updatePolicy);
    }

    public UpdateSetStrategy(boolean provideDefaults, int updatePolicy) {
        this.provideDefaults = provideDefaults;
        this.updatePolicy = updatePolicy;
    }

    protected void fillDefaults(IObservableSet<? extends S> source, IObservableSet<? super D> destination) {
        Object sourceType = source.getElementType();
        Object destinationType = destination.getElementType();
        if (this.provideDefaults && sourceType != null && destinationType != null && this.converter == null) {
            this.setConverter(this.createConverter(sourceType, destinationType));
        }
        if (this.converter != null) {
            if (sourceType != null) {
                this.checkAssignable(this.converter.getFromType(), sourceType, "converter does not convert from type " + sourceType);
            }
            if (destinationType != null) {
                this.checkAssignable(destinationType, this.converter.getToType(), "converter does not convert to type " + destinationType);
            }
        }
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public UpdateSetStrategy<S, D> setConverter(IConverter<S, D> converter) {
        this.converter = converter;
        return this;
    }

    protected IStatus doAdd(IObservableSet<? super D> observableSet, D element) {
        try {
            observableSet.add(element);
        }
        catch (Exception ex) {
            return this.logErrorWhileSettingValue(ex);
        }
        return Status.OK_STATUS;
    }

    protected IStatus doRemove(IObservableSet<? super D> observableSet, D element) {
        try {
            observableSet.remove(element);
        }
        catch (Exception ex) {
            return this.logErrorWhileSettingValue(ex);
        }
        return Status.OK_STATUS;
    }
}

