/*
 * Decompiled with CFR 0.152.
 */
package com.naef.jnlua.script;

import com.naef.jnlua.LuaState;
import com.naef.jnlua.script.LuaScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class LuaScriptEngineFactory
implements ScriptEngineFactory {
    private static final String ENGINE_NAME = "JNLua";
    private static final String LANGUAGE_NAME = "Lua";
    private static final List<String> EXTENSIONS;
    private static final List<String> MIME_TYPES;
    private static final List<String> NAMES;

    static {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("lua");
        EXTENSIONS = Collections.unmodifiableList(extensions);
        ArrayList<String> mimeTypes = new ArrayList<String>();
        mimeTypes.add("application/x-lua");
        mimeTypes.add("text/x-lua");
        MIME_TYPES = Collections.unmodifiableList(mimeTypes);
        ArrayList<String> names = new ArrayList<String>();
        names.add("lua");
        names.add(LANGUAGE_NAME);
        names.add("jnlua");
        names.add(ENGINE_NAME);
        NAMES = Collections.unmodifiableList(names);
    }

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return "1.0";
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return NAMES;
    }

    @Override
    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    @Override
    public String getLanguageVersion() {
        return LuaState.LUA_VERSION;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getNames().get(0);
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuffer sb = new StringBuffer();
        sb.append(obj);
        sb.append(':');
        sb.append(m);
        sb.append('(');
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(args[i]);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuffer sb = new StringBuffer();
        sb.append("print(");
        this.quoteString(sb, toDisplay);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < statements.length) {
            sb.append(statements[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new LuaScriptEngine(this);
    }

    private void quoteString(StringBuffer sb, String s) {
        sb.append('\"');
        int i = 0;
        while (i < s.length()) {
            switch (s.charAt(i)) {
                case '\u0007': {
                    sb.append("\\a");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\u000b': {
                    sb.append("\\v");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
            ++i;
        }
        sb.append('\"');
    }
}

