/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.IExportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ExportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CreateExportOperation
extends CreateElementInCUOperation {
    protected String exportName;
    protected int flags;

    public CreateExportOperation(String exportName, IJavaScriptUnit parentElement, int flags) {
        super(parentElement);
        this.exportName = exportName;
        this.flags = flags;
    }

    @Override
    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
        return JavaScriptUnit.EXPORTS_PROPERTY;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, IJavaScriptUnit cu) throws JavaScriptModelException {
        Iterator<ASTNode> exports = this.cuAST.exports().iterator();
        String exportActualName = this.exportName;
        while (exports.hasNext()) {
            ExportDeclaration cfr_ignored_0 = (ExportDeclaration)exports.next();
        }
        AST ast = this.cuAST.getAST();
        ExportDeclaration exportDeclaration = ast.newExportDeclaration();
        char[][] charFragments = CharOperation.splitOn('.', exportActualName.toCharArray(), 0, exportActualName.length());
        int length = charFragments.length;
        String[] strFragments = new String[length];
        int i = 0;
        while (i < length) {
            strFragments[i] = String.valueOf(charFragments[i]);
            ++i;
        }
        ast.newName(strFragments);
        return exportDeclaration;
    }

    @Override
    protected IJavaScriptElement generateResultHandle() {
        return this.getCompilationUnit().getExport(this.exportName);
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createImportsProgress;
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            IJavaScriptUnit cu = this.getCompilationUnit();
            IExportDeclaration[] exports = cu.getExports();
            if (exports.length > 0) {
                this.createAfter(exports[exports.length - 1]);
                return;
            }
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                this.createBefore(types[0]);
                return;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    @Override
    public IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IJavaScriptProject project = this.getParentElement().getJavaScriptProject();
        if (JavaScriptConventions.validateImportDeclaration(this.exportName, project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.exportName);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

