/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.wb.internal.core.utils.xml.parser.QAttribute;
import org.eclipse.wb.internal.core.utils.xml.parser.QException;
import org.eclipse.wb.internal.core.utils.xml.parser.QHandler;

public final class QParser {
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int DONE = 11;
    private static final int DOCTYPE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;

    public static void parse(Reader reader, QHandler handler) throws Exception {
        Stack<Integer> st = new Stack<Integer>();
        int depth = 0;
        int mode = 15;
        int quotec = 34;
        depth = 0;
        StringBuffer sb = new StringBuffer();
        StringBuffer etag = new StringBuffer();
        String tagName = null;
        String lvalue = null;
        String rvalue = null;
        QAttribute attribute = null;
        TreeMap<String, String> attrs = null;
        ArrayList<QAttribute> attrList = null;
        handler.startDocument();
        int line = 1;
        int col = 0;
        boolean eol = false;
        int offset = 0;
        int startTagOffset = 0;
        while (true) {
            int c = reader.read();
            ++offset;
            if (c == -1) break;
            if (c == 10 && eol) {
                eol = false;
            } else if (eol) {
                eol = false;
            } else if (c == 10) {
                ++line;
                col = 0;
            } else if (c == 13) {
                eol = true;
                ++line;
                col = 0;
            } else {
                ++col;
            }
            if (mode == 11) {
                handler.endDocument();
                return;
            }
            if (mode == 1) {
                if (c == 60) {
                    st.push(mode);
                    mode = 5;
                    startTagOffset = offset - 1;
                    if (sb.length() <= 0) continue;
                    handler.text(sb.toString(), false);
                    sb.setLength(0);
                    continue;
                }
                if (c == 38) {
                    st.push(mode);
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 4) {
                if (c == 62) {
                    mode = QParser.popMode(st);
                    tagName = sb.toString();
                    sb.setLength(0);
                    if (--depth == 0) {
                        mode = 11;
                    }
                    handler.endElement(startTagOffset, offset, tagName);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 16) {
                if (c == 62 && sb.toString().endsWith("]]")) {
                    sb.setLength(sb.length() - 2);
                    handler.text(sb.toString(), true);
                    sb.setLength(0);
                    mode = QParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 13) {
                if (c == 62 && sb.toString().endsWith("--")) {
                    sb.setLength(0);
                    mode = QParser.popMode(st);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 15) {
                if (c != 60) continue;
                mode = 1;
                st.push(mode);
                mode = 5;
                startTagOffset = offset - 1;
                continue;
            }
            if (mode == 14) {
                if (c != 62 || (mode = QParser.popMode(st)) != 1) continue;
                mode = 15;
                continue;
            }
            if (mode == 5) {
                mode = QParser.popMode(st);
                if (c == 47) {
                    st.push(mode);
                    mode = 4;
                    continue;
                }
                if (c == 63) {
                    mode = 14;
                    continue;
                }
                st.push(mode);
                mode = 3;
                tagName = null;
                attrs = new TreeMap<String, String>();
                attrList = new ArrayList<QAttribute>();
                sb.append((char)c);
                continue;
            }
            if (mode == 2) {
                if (c == 59) {
                    mode = QParser.popMode(st);
                    String cent = etag.toString();
                    etag.setLength(0);
                    if (cent.equals("lt")) {
                        sb.append('<');
                        continue;
                    }
                    if (cent.equals("gt")) {
                        sb.append('>');
                        continue;
                    }
                    if (cent.equals("amp")) {
                        sb.append('&');
                        continue;
                    }
                    if (cent.equals("quot")) {
                        sb.append('\"');
                        continue;
                    }
                    if (cent.equals("apos")) {
                        sb.append('\'');
                        continue;
                    }
                    if (cent.startsWith("#")) {
                        if ((cent = cent.substring(1)).startsWith("x")) {
                            cent = cent.substring(1);
                            sb.append((char)Integer.parseInt(cent, 16));
                            continue;
                        }
                        sb.append((char)Integer.parseInt(cent));
                        continue;
                    }
                    sb.append("&" + cent + ";");
                    continue;
                }
                etag.append((char)c);
                continue;
            }
            if (mode == 12) {
                if (tagName == null) {
                    tagName = sb.toString();
                }
                if (c != 62) {
                    QParser.throwException("Expected > for tag: <" + tagName + "/>", line, col);
                }
                handler.startElement(startTagOffset, -1, tagName, attrs, attrList, true);
                handler.endElement(-1, offset, tagName);
                if (depth == 0) {
                    handler.endDocument();
                    return;
                }
                sb.setLength(0);
                attrs = new TreeMap();
                attrList = new ArrayList();
                tagName = null;
                mode = QParser.popMode(st);
                continue;
            }
            if (mode == 3) {
                if (c == 62) {
                    if (tagName == null) {
                        tagName = sb.toString();
                    }
                    sb.setLength(0);
                    ++depth;
                    handler.startElement(startTagOffset, offset - startTagOffset, tagName, attrs, attrList, false);
                    tagName = null;
                    attrs = new TreeMap();
                    attrList = new ArrayList();
                    mode = QParser.popMode(st);
                    continue;
                }
                if (c == 47) {
                    mode = 12;
                    continue;
                }
                if (c == 45 && sb.toString().equals("!-")) {
                    mode = 13;
                    continue;
                }
                if (c == 91 && sb.toString().equals("![CDATA")) {
                    mode = 16;
                    sb.setLength(0);
                    continue;
                }
                if (c == 69 && sb.toString().equals("!DOCTYP")) {
                    sb.setLength(0);
                    mode = 14;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    tagName = sb.toString();
                    sb.setLength(0);
                    mode = 8;
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 7) {
                if (c == quotec) {
                    rvalue = sb.toString();
                    sb.setLength(0);
                    attribute.setValue(rvalue);
                    attribute.setValueEndOffset(offset - 1);
                    attrList.add(attribute);
                    attribute = null;
                    attrs.put(lvalue, rvalue);
                    mode = 8;
                    continue;
                }
                if (" \r\n\t".indexOf(c) >= 0) {
                    sb.append(' ');
                    continue;
                }
                if (c == 38) {
                    st.push(mode);
                    mode = 2;
                    etag.setLength(0);
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 10) {
                if (c == 34 || c == 39) {
                    quotec = c;
                    attribute.setValueOffset(offset);
                    mode = 7;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                QParser.throwException("Error in attribute processing", line, col);
                continue;
            }
            if (mode == 6) {
                if (Character.isWhitespace((char)c)) {
                    lvalue = sb.toString();
                    sb.setLength(0);
                    attribute.setName(lvalue);
                    attribute.setNameEndOffset(offset - 1);
                    mode = 9;
                    continue;
                }
                if (c == 61) {
                    lvalue = sb.toString();
                    sb.setLength(0);
                    attribute.setName(lvalue);
                    attribute.setNameEndOffset(offset - 1);
                    mode = 10;
                    continue;
                }
                sb.append((char)c);
                continue;
            }
            if (mode == 9) {
                if (c == 61) {
                    mode = 10;
                    continue;
                }
                if (Character.isWhitespace((char)c)) continue;
                QParser.throwException("Error in attribute processing", line, col);
                continue;
            }
            if (mode != 8) continue;
            if (c == 62) {
                mode = QParser.popMode(st);
                handler.startElement(startTagOffset, offset - startTagOffset, tagName, attrs, attrList, false);
                ++depth;
                tagName = null;
                attrs = new TreeMap();
                attrList = new ArrayList();
                continue;
            }
            if (c == 47) {
                mode = 12;
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            mode = 6;
            attribute = new QAttribute();
            attribute.setNameOffset(offset - 1);
            sb.append((char)c);
        }
        if (mode == 11) {
            handler.endDocument();
        } else {
            QParser.throwException("missing end tag", line, col);
        }
    }

    private static int popMode(Stack<Integer> stack) {
        if (stack.empty()) {
            return 15;
        }
        return stack.pop();
    }

    private static void throwException(String message, int line, int col) throws Exception {
        throw new QException(String.valueOf(message) + " near line " + line + ", column " + col);
    }
}

