/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wb.draw2d.geometry.Point;

public final class Dimension
implements Serializable {
    private static final long serialVersionUID = 0L;
    public int width;
    public int height;

    public Dimension() {
    }

    public Dimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Dimension(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public Dimension(org.eclipse.swt.graphics.Point point) {
        this.width = point.x;
        this.height = point.y;
    }

    public Dimension(Image image) {
        Rectangle bounds = image.getBounds();
        this.width = bounds.width;
        this.height = bounds.height;
    }

    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public boolean contains(Dimension dimension) {
        return this.width >= dimension.width && this.height >= dimension.height;
    }

    public boolean containsProper(Dimension dimension) {
        return this.width > dimension.width && this.height > dimension.height;
    }

    public int getArea() {
        return this.width * this.height;
    }

    public boolean equals(int _width, int _height) {
        return this.width == _width && this.height == _height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public Dimension expand(Dimension dimension) {
        this.width += dimension.width;
        this.height += dimension.height;
        return this;
    }

    public Dimension expand(Point point) {
        this.width += point.x;
        this.height += point.y;
        return this;
    }

    public Dimension expand(int _width, int _height) {
        this.width += _width;
        this.height += _height;
        return this;
    }

    public Dimension intersect(Dimension dimension) {
        this.width = Math.min(dimension.width, this.width);
        this.height = Math.min(dimension.height, this.height);
        return this;
    }

    public Dimension negate() {
        this.width = -this.width;
        this.height = -this.height;
        return this;
    }

    public Dimension scale(double amount) {
        return this.scale(amount, amount);
    }

    public Dimension scale(double _width, double _height) {
        this.width = (int)Math.floor((double)this.width * _width);
        this.height = (int)Math.floor((double)this.height * _height);
        return this;
    }

    public Dimension shrink(int w, int h) {
        return this.expand(-w, -h);
    }

    public Dimension transpose() {
        int temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public Dimension union(Dimension dimension) {
        return this.union(dimension.width, dimension.height);
    }

    public Dimension union(int _width, int _height) {
        this.width = Math.max(this.width, _width);
        this.height = Math.max(this.height, _height);
        return this;
    }

    public Dimension getCopy() {
        return new Dimension(this);
    }

    public Dimension getDifference(Dimension dimension) {
        return new Dimension(this.width - dimension.width, this.height - dimension.height);
    }

    public Dimension getExpanded(Dimension dimension) {
        return new Dimension(this.width + dimension.width, this.height + dimension.height);
    }

    public Dimension getExpanded(int _width, int _height) {
        return new Dimension(this.width + _width, this.height + _height);
    }

    public Dimension getIntersected(Dimension dimension) {
        return new Dimension(this).intersect(dimension);
    }

    public Dimension getNegated() {
        return new Dimension(-this.width, -this.height);
    }

    public Dimension getScaled(double amount) {
        return new Dimension(this).scale(amount);
    }

    public Dimension getTransposed() {
        return new Dimension(this).transpose();
    }

    public Dimension getUnioned(Dimension dimension) {
        return new Dimension(this).union(dimension);
    }

    public Dimension getUnioned(int _width, int _height) {
        return new Dimension(this).union(_width, _height);
    }

    public boolean equals(Object object) {
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            return dimension.width == this.width && dimension.height == this.height;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.width;
        result = result * 31 + this.height;
        return result;
    }

    public String toString() {
        return "Dimension(" + this.width + ", " + this.height + ")";
    }
}

