/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event;

import java.util.HashMap;
import java.util.Map;

public class CTFClock {
    private static final long ONE_BILLION_L = 1000000000L;
    private static final double ONE_BILLION_D = 1.0E9;
    private static final String NAME = "name";
    private static final String FREQ = "freq";
    private static final String OFFSET = "offset";
    private long fClockOffset = 0L;
    private double fClockScale = 1.0;
    private double fClockAntiScale = 1.0;
    private final Map<String, Object> fProperties = new HashMap<String, Object>();
    private String fName;
    private boolean fIsScaled = false;

    public void addAttribute(String key, Object value) {
        this.fProperties.put(key, value);
        if (key.equals(NAME)) {
            this.fName = (String)value;
        }
        if (key.equals(FREQ)) {
            this.fIsScaled = !((Long)this.getProperty(FREQ)).equals(1000000000L);
            this.fClockScale = 1.0E9 / ((Long)this.getProperty(FREQ)).doubleValue();
            this.fClockAntiScale = 1.0 / this.fClockScale;
        }
        if (key.equals(OFFSET)) {
            this.fClockOffset = (Long)this.getProperty(OFFSET);
        }
    }

    public String getName() {
        return this.fName;
    }

    public Object getProperty(String key) {
        return this.fProperties.get(key);
    }

    public long getClockOffset() {
        return this.fClockOffset;
    }

    public double getClockScale() {
        return this.fClockScale;
    }

    public double getClockAntiScale() {
        return this.fClockAntiScale;
    }

    public boolean isClockScaled() {
        return this.fIsScaled;
    }
}

