/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractExtendedContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener,
ISelectionListener {
    private static final int SET_SELECTION_JOB_SCHEDULE_DELAY = 300;
    protected Job setSelectionJob;
    private ListenerList selectionChangedListeners = new ListenerList();
    private Composite control;
    private FilteredTree filteredTree;
    private TreeViewer treeViewer;

    protected AbstractExtendedContentOutlinePage() {
    }

    private boolean hasAtMostOneView(TreeViewer tree) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)tree.getContentProvider();
        Object[] children = contentProvider.getElements(tree.getInput());
        boolean result = false;
        if (children.length <= 1) {
            result = children.length == 0 ? true : !contentProvider.hasChildren(children[0]);
        }
        return result;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected FilteredTree createFilteredTree(Composite parent) {
        return SWTUtil.createFilteredTree((Composite)parent, (int)2818, (PatternFilter)new PatternFilter());
    }

    public void createControl(Composite parent) {
        this.control = SWTUtil.createCompositeBothFill((Composite)parent, (int)1, (boolean)false);
        this.filteredTree = this.createFilteredTree(this.control);
        this.treeViewer = this.filteredTree.getViewer();
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.getTree().dispose();
        this.filteredTree.dispose();
        super.dispose();
    }

    public void endControl(Composite parent) {
        Text filterText;
        this.filteredTree.setBackground(parent.getDisplay().getSystemColor(22));
        if (this.hasAtMostOneView(this.filteredTree.getViewer()) && (filterText = this.filteredTree.getFilterControl()) != null) {
            filterText.setEnabled(false);
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public Control getControl() {
        return this.control;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setSelection(final ISelection selection) {
        if (this.setSelectionJob != null) {
            this.setSelectionJob.cancel();
        }
        this.setSelectionJob = new Job(Messages.AbstractExtendedContentOutlinePage_setSelectionJobName){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractExtendedContentOutlinePage.this.treeViewer != null) {
                            AbstractExtendedContentOutlinePage.this.treeViewer.setSelection(selection);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.setSelectionJob.setSystem(true);
        this.setSelectionJob.schedule(300L);
    }

    protected IStructuredSelection createStructuredSelectionWrapper(IStructuredSelection originalSelection) {
        ArrayList<Object> elements = new ArrayList<Object>(originalSelection.toList().size());
        for (Object obj : originalSelection.toList()) {
            if (obj instanceof EditPart) {
                EObject element;
                EditPart editPart = (EditPart)obj;
                if (!(editPart.getModel() instanceof View) || (element = ((View)editPart.getModel()).getElement()) == null) continue;
                elements.add(element);
                continue;
            }
            elements.add(obj);
        }
        return new StructuredSelection(elements);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof ContentOutline) && selection instanceof IStructuredSelection) {
            this.setSelection((ISelection)this.createStructuredSelectionWrapper((IStructuredSelection)selection));
        }
    }
}

