/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.permission;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.sourcebuilder.permission.PermissionSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class PermissionNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider;
    private String m_permissionName;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private String m_package;
    private IType m_superType;
    private IType m_createdPermission;

    public PermissionNewOperation() {
        this(new CachingJavaEnvironmentProvider());
    }

    protected PermissionNewOperation(IJavaEnvironmentProvider provider) {
        this.m_javaEnvironmentProvider = (IJavaEnvironmentProvider)Validate.notNull((Object)provider);
    }

    @Override
    public String getOperationName() {
        return "Create Permission '" + this.getPermissionName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPermissionName()), (String)"No permission name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()), (String)"No source folder provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPackage()), (String)"No package name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSuperType()), (String)"No supertype provided", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)1);
        this.setCreatedPermission(this.createPermission((IProgressMonitor)progress.newChild(1), workingCopyManager));
    }

    protected IType createPermission(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        IJavaEnvironment env = this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject());
        PermissionSourceBuilder psb = new PermissionSourceBuilder(this.getPermissionName(), this.getPackage(), env);
        psb.setup();
        psb.getMainType().setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)psb, env, monitor, workingCopyManager);
    }

    public IType getCreatedPermission() {
        return this.m_createdPermission;
    }

    protected void setCreatedPermission(IType createdPermission) {
        this.m_createdPermission = createdPermission;
    }

    public String getPermissionName() {
        return this.m_permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.m_permissionName = permissionName;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }
}

