/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.spy.view.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.core.util.TextWidgetUtil;
import org.eclipse.reddeer.spy.view.RedDeerSpy;
import org.eclipse.reddeer.spy.widget.ListChild;
import org.eclipse.reddeer.spy.widget.resolver.WidgetResolver;
import org.eclipse.reddeer.swt.api.Combo;
import org.eclipse.reddeer.swt.api.ExpandBar;
import org.eclipse.reddeer.swt.api.Group;
import org.eclipse.reddeer.swt.api.MenuItem;
import org.eclipse.reddeer.swt.api.Scale;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.Table;
import org.eclipse.reddeer.swt.api.ToolBar;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class RedDeerWidgetTracker
implements Runnable {
    private RedDeerSpy spy;
    private WidgetResolver widgetResolver;
    private List<StyleRange> styleRanges;
    private static final String ANONYMOUS_COMPOSITE = "anonymous org.eclipse.swt.widgets.Composite";

    public RedDeerWidgetTracker(RedDeerSpy spy) {
        this.spy = spy;
        this.widgetResolver = WidgetResolver.getInstance();
    }

    @Override
    public void run() {
        if (this.spy.getOutput() == null || this.spy.getOutput().isDisposed() || !this.spy.getAction().isChecked()) {
            return;
        }
        Display display = this.spy.getOutput().getDisplay();
        Control control = display.getCursorControl();
        if (control == null) {
            this.spy.getOutput().setText("");
            this.spy.setLastWidget(null);
        } else if (control != this.spy.getLastWidget()) {
            this.spy.setLastWidget((Widget)control);
            StringBuffer stringBuffer = new StringBuffer();
            this.styleRanges = new ArrayList<StyleRange>();
            this.getInformation(control, stringBuffer);
            this.spy.getOutput().setText(stringBuffer.toString());
            this.spy.getOutput().setStyleRanges(this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]));
        }
        display.timerExec(70, this.spy.getWidgetTracker());
    }

    private void getInformation(Control control, StringBuffer stringBuffer) {
        stringBuffer.append("To start/stop spying on widgets press CTRL+ALT:\n\n");
        this.getWidgetInformation(control, stringBuffer);
        this.getSiblingsInformation(control, stringBuffer);
        this.getChildrenInformation(control, stringBuffer);
        this.getWidgetTreeInformation(control, stringBuffer);
    }

    private void getWidgetInformation(Control control, StringBuffer stringBuffer) {
        this.addBoldText("Widget information:", stringBuffer);
        stringBuffer.append("\n");
        stringBuffer.append("\t");
        this.addBoldText("Class:", stringBuffer);
        String output = control.getClass().getCanonicalName();
        if (output == null) {
            output = ANONYMOUS_COMPOSITE;
        }
        stringBuffer.append(" " + output + "\n");
        String text = this.getText(control);
        stringBuffer.append("\t");
        this.addBoldText("Text:", stringBuffer);
        if (text != null) {
            stringBuffer.append(" \"" + text + "\"\n");
        } else {
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t");
        this.addBoldText("Possible RedDeer API for widget:", stringBuffer);
        stringBuffer.append("\n");
        StringBuilder redDeerWidgets = new StringBuilder();
        for (String widget : this.getPossibleRedDeerWidget(control)) {
            redDeerWidgets.append("\t\t" + widget + "\n");
        }
        stringBuffer.append(String.valueOf(redDeerWidgets.toString()) + "\n");
    }

    private void getSiblingsInformation(Control control, StringBuffer stringBuffer) {
        this.addBoldText("Siblings:", stringBuffer);
        stringBuffer.append("\n");
        Widget parent = this.widgetResolver.getParent((Widget)control);
        List<Object> siblingWidgets = new ArrayList();
        if (parent != null) {
            siblingWidgets = this.widgetResolver.getChildren(parent);
        }
        if (siblingWidgets.size() > 1) {
            for (Widget widget : siblingWidgets) {
                if (widget.equals(control)) continue;
                stringBuffer.append(String.valueOf(this.getWidgetOutput(widget)) + "\n");
            }
        }
        stringBuffer.append("\n");
    }

    private void getWidgetTreeInformation(Control control, StringBuffer stringBuffer) {
        this.addBoldText("Widget tree:", stringBuffer);
        stringBuffer.append("\n");
        boolean hasSiblings = false;
        if (this.widgetResolver.getParent((Widget)control) != null) {
            hasSiblings = this.widgetResolver.getChildren(this.widgetResolver.getParent((Widget)control)).size() > 0;
        }
        Control parentWidget = control;
        LinkedList<String> parentTree = new LinkedList<String>();
        while (this.widgetResolver.hasParent((Widget)parentWidget)) {
            parentWidget = this.widgetResolver.getParent((Widget)parentWidget);
            parentTree.add(this.getWidgetOutput((Widget)parentWidget));
        }
        if (parentTree.size() > 0) {
            stringBuffer.append(String.valueOf((String)parentTree.get(parentTree.size() - 1)) + "\n");
        }
        String spacing = "";
        int i = parentTree.size() - 2;
        while (i > 0) {
            stringBuffer.append(String.valueOf(spacing) + "\u2514\u2500" + (String)parentTree.get(i) + "\n");
            spacing = String.valueOf(spacing) + "  ";
            --i;
        }
        ArrayList siblings = hasSiblings ? this.widgetResolver.getChildren(this.widgetResolver.getParent((Widget)control)) : new ArrayList();
        int i2 = 0;
        while (i2 < siblings.size()) {
            if (i2 == siblings.size() - 1) {
                stringBuffer.append(String.valueOf(spacing) + "\u2514\u2500");
            } else {
                stringBuffer.append(String.valueOf(spacing) + "\u251c\u2500");
            }
            if (((Widget)siblings.get(i2)).equals(control)) {
                this.addBoldText(this.getWidgetOutput((Widget)control), stringBuffer);
                stringBuffer.append("\n");
                List<Widget> children = this.widgetResolver.getChildren((Widget)control);
                String childrenSpacing = siblings.size() > 1 && i2 + 1 < siblings.size() ? String.valueOf(spacing) + "\u2502 " : String.valueOf(spacing) + "  ";
                int k = 0;
                while (k < children.size()) {
                    if (k == children.size() - 1) {
                        stringBuffer.append(String.valueOf(childrenSpacing) + "\u2514\u2500" + this.getWidgetOutput(children.get(k)) + "\n");
                    } else {
                        stringBuffer.append(String.valueOf(childrenSpacing) + "\u251c\u2500" + this.getWidgetOutput(children.get(k)) + "\n");
                    }
                    ++k;
                }
            } else {
                stringBuffer.append(String.valueOf(this.getWidgetOutput((Widget)siblings.get(i2))) + "\n");
            }
            ++i2;
        }
    }

    private void getChildrenInformation(Control control, StringBuffer stringBuffer) {
        this.addBoldText("Children:", stringBuffer);
        stringBuffer.append("\n");
        for (Widget widget : this.widgetResolver.getChildren((Widget)control)) {
            String output = widget.getClass().getCanonicalName();
            if (output == null) {
                output = ANONYMOUS_COMPOSITE;
            }
            String childText = null;
            if (widget instanceof Control) {
                childText = this.getText((Control)widget);
            } else if (widget instanceof ListChild) {
                childText = ((ListChild)widget).getText();
            }
            if (childText != null) {
                output = String.valueOf(output) + " [\"" + childText + "\"]";
            }
            stringBuffer.append(String.valueOf(output) + "\n");
        }
        stringBuffer.append("\n");
    }

    private void addBoldText(String text, StringBuffer stringBuffer) {
        this.addStyleRange(stringBuffer.length(), text.length());
        stringBuffer.append(text);
    }

    private void addStyleRange(int startPosition, int length) {
        StyleRange newStyle = new StyleRange();
        newStyle.start = startPosition;
        newStyle.length = length;
        newStyle.fontStyle = 1;
        this.styleRanges.add(newStyle);
    }

    private List<String> getPossibleRedDeerWidget(Control control) {
        ArrayList<String> widgets = new ArrayList<String>();
        Class<?> clazz = control.getClass();
        if (clazz.equals(Browser.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.Browser.class.getCanonicalName());
        } else if (clazz.equals(Button.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.Button.class.getCanonicalName());
        } else if (clazz.equals(CLabel.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.CLabel.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.Combo.class)) {
            widgets.add(Combo.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.ExpandBar.class)) {
            widgets.add(ExpandBar.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.Group.class)) {
            widgets.add(Group.class.getCanonicalName());
        } else if (clazz.equals(Label.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.Label.class.getCanonicalName());
        } else if (clazz.equals(Link.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.Link.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.List.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.List.class.getCanonicalName());
        } else if (clazz.equals(Menu.class)) {
            widgets.add(MenuItem.class.getCanonicalName());
        } else if (clazz.equals(ProgressBar.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.ProgressBar.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.Scale.class)) {
            widgets.add(Scale.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.Shell.class)) {
            widgets.add(Shell.class.getCanonicalName());
        } else if (clazz.equals(Spinner.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.Spinner.class.getCanonicalName());
        } else if (clazz.equals(StyledText.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.StyledText.class.getCanonicalName());
        } else if (clazz.equals(TabFolder.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.TabFolder.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.Table.class)) {
            widgets.add(Table.class.getCanonicalName());
        } else if (clazz.equals(Text.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.Text.class.getCanonicalName());
        } else if (clazz.equals(org.eclipse.swt.widgets.ToolBar.class)) {
            widgets.add(ToolBar.class.getCanonicalName());
        } else if (clazz.equals(Tree.class)) {
            widgets.add(org.eclipse.reddeer.swt.api.Tree.class.getCanonicalName());
        }
        return widgets;
    }

    private String getText(Control widget) {
        String text = null;
        try {
            text = TextWidgetUtil.getText((Widget)widget);
        }
        catch (RedDeerException redDeerException) {}
        return text;
    }

    private String getWidgetOutput(Widget widget) {
        String output = widget.getClass().getCanonicalName();
        if (output == null) {
            output = ANONYMOUS_COMPOSITE;
        }
        String widgetText = null;
        if (widget instanceof Control) {
            widgetText = this.getText((Control)widget);
        } else if (widget instanceof ListChild) {
            widgetText = ((ListChild)widget).getText();
        }
        if (widgetText != null) {
            output = String.valueOf(output) + " [\"" + widgetText + "\"]";
        }
        return output;
    }
}

