/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecNode;
import org.eclipse.photran.internal.core.parser.ASTAttrSpecSeqNode;
import org.eclipse.photran.internal.core.parser.ASTDataRefNode;
import org.eclipse.photran.internal.core.parser.ASTDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDatalistNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTSaveStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSavedEntityNode;
import org.eclipse.photran.internal.core.parser.ASTSeparatedListNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVariableNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class MakeSaveExplicitRefactoring
extends FortranResourceRefactoring {
    private IFortranAST currAST = null;

    @Override
    public String getName() {
        return Messages.MakeSaveExplicitRefactoring_Name;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError(Messages.bind((String)Messages.MakeSaveExplicitRefactoring_SelectedFileCannotBeParsed, (Object)file.getName()));
                    continue;
                }
                this.currAST = ast;
                this.makeChangesTo(file, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private void makeChangesTo(IFile file, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        for (ScopingNode scope : this.currAST.getRoot().getAllContainedScopes()) {
            SavedVariableVisitor savedVariableVisitor = new SavedVariableVisitor();
            scope.accept(savedVariableVisitor);
            if (savedVariableVisitor.hasGlobalSaveStmt() || scope.isMainProgram()) continue;
            HashSet<String> explicitlySavedVariables = savedVariableVisitor.getExplicitlySavedVariables();
            TreeSet<String> dataVariables = savedVariableVisitor.getDataBlockVariables();
            this.makeAllSaveAttributesExplicit(scope, explicitlySavedVariables, dataVariables);
        }
        this.addChangeFromModifiedAST(file, pm);
    }

    private void makeAllSaveAttributesExplicit(ScopingNode scope, HashSet<String> explicitlySavedVariables, TreeSet<String> dataEntities) throws VPGRefactoring.PreconditionFailure {
        if (scope.getBody() == null) {
            return;
        }
        for (IASTNode iASTNode : scope.getBody().getChildren()) {
            if (!(iASTNode instanceof ASTTypeDeclarationStmtNode)) continue;
            ASTTypeDeclarationStmtNode declarationNode = (ASTTypeDeclarationStmtNode)iASTNode;
            this.makeImplicitlySavedVariablesExplicitlySaved(scope, declarationNode, dataEntities, explicitlySavedVariables);
        }
        for (String string : dataEntities) {
            if (explicitlySavedVariables.contains(string.toLowerCase())) continue;
            this.addVariableToSaveStmt(scope, string);
            explicitlySavedVariables.add(string.toLowerCase());
        }
    }

    private void makeImplicitlySavedVariablesExplicitlySaved(ScopingNode scope, ASTTypeDeclarationStmtNode typeDeclaration, TreeSet<String> dataEntities, HashSet<String> savedEntities) {
        IASTListNode<ASTEntityDeclNode> entityDeclList = typeDeclaration.getEntityDeclList();
        boolean declContainsSavedAndUnsavedVariables = this.containsUnsavedAndSavedVariables(typeDeclaration, dataEntities);
        for (ASTEntityDeclNode variableDeclaration : entityDeclList) {
            if (!this.isImplicitlySaved(scope, variableDeclaration, dataEntities) || savedEntities.contains(this.declarationVariableName(variableDeclaration).toLowerCase())) continue;
            if (!declContainsSavedAndUnsavedVariables) {
                String declString = SourcePrinter.getSourceCodeFromASTNode(typeDeclaration);
                ASTAttrSpecSeqNode attrSpecSeqNode = this.createSaveAttrSpecSeqNode(!declString.contains("::"));
                if (typeDeclaration.getAttrSpecSeq() == null) {
                    ASTListNode<ASTAttrSpecSeqNode> attrSpecSeq = new ASTListNode<ASTAttrSpecSeqNode>(1);
                    typeDeclaration.setAttrSpecSeq(attrSpecSeq);
                }
                typeDeclaration.getAttrSpecSeq().add(attrSpecSeqNode);
                for (ASTEntityDeclNode decl : typeDeclaration.getEntityDeclList()) {
                    savedEntities.add(this.declarationVariableName(decl).toLowerCase());
                }
                return;
            }
            String variableName = this.declarationVariableName(variableDeclaration);
            savedEntities.add(variableName.toLowerCase());
            this.addVariableToSaveStmt(scope, variableName);
        }
    }

    private void addVariableToSaveStmt(ScopingNode scope, String variableName) {
        ASTSavedEntityNode savedEntity = new ASTSavedEntityNode();
        Token savedEntityToken = new Token(Terminal.T_IDENT, variableName);
        savedEntity.setVariableName(savedEntityToken);
        for (IASTNode iASTNode : scope.getBody().getChildren()) {
            if (!(iASTNode instanceof ASTSaveStmtNode)) continue;
            IASTListNode<ASTSavedEntityNode> variableList = ((ASTSaveStmtNode)iASTNode).getVariableList();
            ASTSeparatedListNode astSeparatedListNode = (ASTSeparatedListNode)variableList;
            astSeparatedListNode.add(new Token(null, ", "), savedEntity);
            return;
        }
        ASTSaveStmtNode aSTSaveStmtNode = (ASTSaveStmtNode)MakeSaveExplicitRefactoring.parseLiteralStatement("SAVE " + variableName);
        IASTListNode<? extends IASTNode> body = scope.getBody();
        body.add(0, aSTSaveStmtNode);
        Reindenter.reindent(aSTSaveStmtNode, this.currAST);
    }

    private boolean containsUnsavedAndSavedVariables(ASTTypeDeclarationStmtNode typeDeclaration, TreeSet<String> dataEntities) {
        if (typeDeclaration.getEntityDeclList() == null) {
            return false;
        }
        boolean containsSaved = false;
        boolean containsUnSaved = false;
        for (ASTEntityDeclNode decl : typeDeclaration.getEntityDeclList()) {
            if (decl.getInitialization() == null && !dataEntities.contains(this.declarationVariableName(decl).toLowerCase())) {
                containsUnSaved = true;
                continue;
            }
            containsSaved = true;
        }
        return containsSaved && containsUnSaved;
    }

    private String declarationVariableName(ASTEntityDeclNode decl) {
        return decl.getObjectName().getObjectName().getText();
    }

    private boolean isImplicitlySaved(ScopingNode scope, ASTEntityDeclNode variableDeclaration, TreeSet<String> dataEntities) {
        return variableDeclaration.getInitialization() != null || dataEntities.contains(this.declarationVariableName(variableDeclaration).toLowerCase());
    }

    private ASTAttrSpecSeqNode createSaveAttrSpecSeqNode(boolean addDblColon) {
        ASTAttrSpecSeqNode attrSpecSeqNode = new ASTAttrSpecSeqNode();
        ASTAttrSpecNode attrSpecNode = new ASTAttrSpecNode();
        Token token = addDblColon ? new Token(null, ", SAVE ::") : new Token(null, ", SAVE");
        attrSpecNode.setIsSave(token);
        attrSpecSeqNode.setAttrSpec(attrSpecNode);
        return attrSpecSeqNode;
    }

    private class SavedVariableVisitor
    extends ASTVisitor {
        private boolean hasGlobalSaveStmt = false;
        private HashSet<String> explicitlySavedVariables = new HashSet();
        private TreeSet<String> dataBlockVariables = new TreeSet();
        private ASTSaveStmtNode saveStmt = null;

        public TreeSet<String> getDataBlockVariables() {
            return this.dataBlockVariables;
        }

        public HashSet<String> getExplicitlySavedVariables() {
            return this.explicitlySavedVariables;
        }

        public boolean hasGlobalSaveStmt() {
            return this.hasGlobalSaveStmt;
        }

        @Override
        public void visitASTSaveStmtNode(ASTSaveStmtNode node) {
            this.saveStmt = node;
            if (node.getVariableList() == null) {
                this.hasGlobalSaveStmt = true;
            } else {
                for (ASTSavedEntityNode variable : node.getVariableList()) {
                    this.explicitlySavedVariables.add(variable.getVariableName().getText().toLowerCase());
                }
            }
        }

        @Override
        public void visitASTTypeDeclarationStmtNode(ASTTypeDeclarationStmtNode node) {
            IASTListNode<ASTAttrSpecSeqNode> attrSpecSeq = node.getAttrSpecSeq();
            if (attrSpecSeq != null) {
                for (ASTAttrSpecSeqNode attrSpecSeqNode : attrSpecSeq) {
                    ASTAttrSpecNode attrSpecNode = attrSpecSeqNode.getAttrSpec();
                    if (attrSpecNode == null || !attrSpecNode.isSave()) continue;
                    for (ASTEntityDeclNode variable : node.getEntityDeclList()) {
                        this.explicitlySavedVariables.add(variable.getObjectName().getObjectName().getText().toLowerCase());
                    }
                }
            }
        }

        @Override
        public void visitASTDataStmtNode(ASTDataStmtNode node) {
            IASTListNode<ASTDatalistNode> dataList = node.getDatalist();
            for (IASTNode iASTNode : dataList.getChildren()) {
                ASTDatalistNode dataListNode = (ASTDatalistNode)iASTNode;
                for (IASTNode iASTNode2 : dataListNode.getDataStmtSet().getDataStmtObjectList().getChildren()) {
                    if (!(iASTNode2 instanceof ASTVariableNode)) continue;
                    ASTVariableNode variableNode = (ASTVariableNode)iASTNode2;
                    String variableName = ((ASTDataRefNode)variableNode.getDataRef().get(0)).getName().getText();
                    this.dataBlockVariables.add(variableName.toLowerCase());
                }
            }
        }
    }
}

