/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IResultSaver;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;

public class ResourceSaver
implements IResultSaver {
    public IStatus canSave(EClassifier cls, URI destUri) {
        URI converted = URIConverter.INSTANCE.normalize(destUri);
        Status okStatus = new Status(0, "org.eclipse.m2m.qvt.oml.emf.util.ui", 0, "", null);
        String scheme = converted.scheme();
        if (converted.isFile()) {
            if (!"file".equals(scheme) && !"platform".equals(scheme)) {
                return new Status(4, "org.eclipse.m2m.qvt.oml.emf.util.ui", 4, Messages.format(Messages.ResourceSaver_UriNotFile, destUri, scheme), null);
            }
        } else {
            if ("archive".equals(scheme)) {
                return okStatus;
            }
            if (converted.isPlatformResource()) {
                return okStatus;
            }
            try {
                URL url = new URL(destUri.toString());
                url.openConnection();
                return okStatus;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Status(4, "org.eclipse.m2m.qvt.oml.emf.util.ui", 4, NLS.bind((String)Messages.ResourceSaver_UriCorrupted, (Object)destUri), null);
    }

    public void clean(URI destUri) throws Exception {
        IFile file = URIUtils.getFile((URI)destUri);
        if (file == null) {
            return;
        }
        file.delete(true, true, null);
    }

    public boolean select(EObject obj, IWorkbenchPage page) throws CoreException {
        Resource resource = obj.eResource();
        if (resource == null) {
            return false;
        }
        URIConverter uriConverter = resource.getResourceSet() != null ? resource.getResourceSet().getURIConverter() : URIConverter.INSTANCE;
        URI uri = uriConverter.normalize(resource.getURI());
        IEditorDescriptor defaultEditorDescriptor = null;
        IFile file = URIUtils.getFile((URI)uri);
        if (file == null || !file.exists()) {
            try {
                defaultEditorDescriptor = IDE.getEditorDescriptor((String)uri.toFileString());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            file = null;
        } else {
            defaultEditorDescriptor = IDE.getDefaultEditor((IFile)file);
            resource.setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
        }
        if (defaultEditorDescriptor == null) {
            return false;
        }
        IEditorPart part = null;
        String defaultID = defaultEditorDescriptor.getId();
        if ("org.eclipse.ui.DefaultTextEditor".equals(defaultID)) {
            part = file == null ? this.openInEditor(page, uri) : this.openEditor(page, file, "org.eclipse.emf.ecore.presentation.ReflectiveEditorID");
        }
        if (part == null) {
            part = file == null ? this.openInEditor(page, uri) : this.openEditor(page, file, defaultID);
        }
        if (part == null) {
            return false;
        }
        if (!(part instanceof IGotoMarker)) {
            return true;
        }
        IGotoMarker gotoMarker = (IGotoMarker)part;
        IMarker marker = this.makeMarker(obj, file);
        try {
            gotoMarker.gotoMarker(marker);
        }
        finally {
            marker.delete();
        }
        return true;
    }

    private IEditorPart openEditor(IWorkbenchPage page, IFile file, String id) {
        try {
            return IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)id, (boolean)true);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    private IEditorPart openInEditor(IWorkbenchPage page, URI uri) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(uri.toFileString()));
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            try {
                return IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return null;
    }

    public URI getUri(EObject obj) {
        return obj == null ? null : EcoreUtil.getURI((EObject)obj);
    }

    private IMarker makeMarker(EObject obj, IFile file) throws CoreException {
        URI uri = EcoreUtil.getURI((EObject)obj);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("uri", String.valueOf(uri));
        ShallowMarker marker = file == null ? new ShallowMarker("org.eclipse.emf.ecore.diagnostic") : file.createMarker("org.eclipse.emf.ecore.diagnostic");
        marker.setAttributes(attributes);
        return marker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShallowMarker
    implements IMarker {
        private final Map<String, Object> myAttributes = new HashMap<String, Object>();
        private final long myCreationTime = System.currentTimeMillis();
        private final String myType;

        public ShallowMarker(String type) {
            this.myType = type;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public void delete() throws CoreException {
        }

        public boolean exists() {
            return false;
        }

        public Object getAttribute(String attributeName) throws CoreException {
            return this.myAttributes.get(attributeName);
        }

        public int getAttribute(String attributeName, int defaultValue) {
            Object object = this.myAttributes.get(attributeName);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return defaultValue;
        }

        public String getAttribute(String attributeName, String defaultValue) {
            Object object = this.myAttributes.get(attributeName);
            if (object instanceof String) {
                return (String)object;
            }
            return defaultValue;
        }

        public boolean getAttribute(String attributeName, boolean defaultValue) {
            Object object = this.myAttributes.get(attributeName);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return defaultValue;
        }

        public Map<String, Object> getAttributes() throws CoreException {
            return this.myAttributes;
        }

        public Object[] getAttributes(String[] attributeNames) throws CoreException {
            Object[] result = new Object[attributeNames.length];
            int i = 0;
            while (i < attributeNames.length) {
                result[i] = this.getAttribute(attributeNames[i]);
                ++i;
            }
            return result;
        }

        public long getCreationTime() throws CoreException {
            return this.myCreationTime;
        }

        public long getId() {
            return this.myCreationTime;
        }

        public IResource getResource() {
            return null;
        }

        public String getType() throws CoreException {
            return "org.eclipse.core.resources.marker";
        }

        public boolean isSubtypeOf(String superType) throws CoreException {
            return this.myType.equals(superType);
        }

        public void setAttribute(String attributeName, int value) throws CoreException {
            this.myAttributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, Object value) throws CoreException {
            this.myAttributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, boolean value) throws CoreException {
            this.myAttributes.put(attributeName, value);
        }

        public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
            Assert.isTrue((attributeNames.length == values.length ? 1 : 0) != 0);
            int i = 0;
            while (i < attributeNames.length) {
                this.setAttribute(attributeNames[i], values[i]);
                ++i;
            }
        }

        public void setAttributes(Map<String, ? extends Object> attributes) throws CoreException {
            this.myAttributes.clear();
            this.myAttributes.putAll(attributes);
        }
    }
}

