/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.dialogs.AbstractMavenDialog;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.util.ProposalUtil;
import org.eclipse.m2e.core.ui.internal.util.Util;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EditDependencyDialog
extends AbstractMavenDialog {
    private static final String[] TYPES = new String[]{"jar", "war", "rar", "ear", "par", "ejb", "ejb-client", "test-jar", "java-source", "javadoc", "maven-plugin", "pom"};
    private final IProject project;
    private String[] scopes;
    protected Text groupIdText;
    protected Text artifactIdText;
    protected Text versionText;
    protected Text classifierText;
    protected Combo typeCombo;
    protected Combo scopeCombo;
    protected Text systemPathText;
    protected Button optionalButton;
    private Dependency dependency;
    private final MavenProject mavenproject;
    private final boolean dependencyManagement;
    private PomEdits.Operation resultOperation;

    public EditDependencyDialog(Shell parent, boolean dependencyManagement, IProject project, MavenProject mavenProject) {
        super(parent, EditDependencyDialog.class.getName());
        this.project = project;
        this.mavenproject = mavenProject;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Messages.EditDependencyDialog_title);
        this.dependencyManagement = dependencyManagement;
        this.scopes = !dependencyManagement ? MavenRepositorySearchDialog.SCOPES : MavenRepositorySearchDialog.DEP_MANAGEMENT_SCOPES;
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(superComposite, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label groupIdLabel = new Label(composite, 0);
        groupIdLabel.setText(Messages.EditDependencyDialog_groupId_label);
        this.groupIdText = new Text(composite, 2048);
        GridData gd_groupIdText = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_groupIdText.horizontalIndent = 4;
        this.groupIdText.setLayoutData((Object)gd_groupIdText);
        ProposalUtil.addGroupIdProposal(this.project, this.groupIdText, Packaging.ALL);
        M2EUIUtils.addRequiredDecoration((Control)this.groupIdText);
        Label artifactIdLabel = new Label(composite, 0);
        artifactIdLabel.setText(Messages.EditDependencyDialog_artifactId_label);
        this.artifactIdText = new Text(composite, 2048);
        GridData gd_artifactIdText = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_artifactIdText.horizontalIndent = 4;
        this.artifactIdText.setLayoutData((Object)gd_artifactIdText);
        ProposalUtil.addArtifactIdProposal(this.project, this.groupIdText, this.artifactIdText, Packaging.ALL);
        M2EUIUtils.addRequiredDecoration((Control)this.artifactIdText);
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(Messages.EditDependencyDialog_version_label);
        this.versionText = new Text(composite, 2048);
        GridData versionTextData = new GridData(16384, 0x1000000, true, false, 2, 1);
        versionTextData.horizontalIndent = 4;
        versionTextData.widthHint = 200;
        this.versionText.setLayoutData((Object)versionTextData);
        ProposalUtil.addVersionProposal(this.project, this.mavenproject, this.groupIdText, this.artifactIdText, this.versionText, Packaging.ALL);
        Label classifierLabel = new Label(composite, 0);
        classifierLabel.setText(Messages.EditDependencyDialog_classifier_label);
        this.classifierText = new Text(composite, 2048);
        GridData gd_classifierText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_classifierText.horizontalIndent = 4;
        gd_classifierText.widthHint = 200;
        this.classifierText.setLayoutData((Object)gd_classifierText);
        ProposalUtil.addClassifierProposal(this.project, this.groupIdText, this.artifactIdText, this.versionText, this.classifierText, Packaging.ALL);
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(Messages.EditDependencyDialog_type_label);
        this.typeCombo = new Combo(composite, 0);
        this.typeCombo.setItems(TYPES);
        GridData gd_typeText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_typeText.horizontalIndent = 4;
        gd_typeText.widthHint = 120;
        this.typeCombo.setLayoutData((Object)gd_typeText);
        Label scopeLabel = new Label(composite, 0);
        scopeLabel.setText(Messages.EditDependencyDialog_scope_label);
        this.scopeCombo = new Combo(composite, 0);
        this.scopeCombo.setItems(this.scopes);
        GridData gd_scopeText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gd_scopeText.horizontalIndent = 4;
        gd_scopeText.widthHint = 120;
        this.scopeCombo.setLayoutData((Object)gd_scopeText);
        Label systemPathLabel = new Label(composite, 0);
        systemPathLabel.setText(Messages.EditDependencyDialog_systemPath_label);
        this.systemPathText = new Text(composite, 2048);
        GridData gd_systemPathText = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_systemPathText.horizontalIndent = 4;
        gd_systemPathText.widthHint = 200;
        this.systemPathText.setLayoutData((Object)gd_systemPathText);
        new Label(composite, 0);
        this.optionalButton = new Button(composite, 32);
        this.optionalButton.setText(Messages.EditDependencyDialog_optional_checkbox);
        GridData gd_optionalButton = new GridData(16384, 128, false, false, 2, 1);
        gd_optionalButton.horizontalIndent = 4;
        this.optionalButton.setLayoutData((Object)gd_optionalButton);
        composite.setTabList(new Control[]{this.groupIdText, this.artifactIdText, this.versionText, this.classifierText, this.typeCombo, this.scopeCombo, this.systemPathText, this.optionalButton});
        this.setDependency(this.dependency);
        return superComposite;
    }

    public PomEdits.Operation getEditOperation() {
        return this.resultOperation;
    }

    protected void computeResult() {
        final String oldArtifactId = this.dependency.getArtifactId();
        final String oldGroupId = this.dependency.getGroupId();
        final String groupId = this.valueOrNull(this.groupIdText.getText());
        final String artifactId = this.valueOrNull(this.artifactIdText.getText());
        final String version = this.valueOrNull(this.versionText.getText());
        final String type = this.valueOrNull(this.typeCombo.getText());
        final String scope = this.valueOrNull(this.scopeCombo.getText());
        final String classifier = this.valueOrNull(this.classifierText.getText());
        final String system = this.valueOrNull(this.systemPathText.getText());
        final boolean optional = this.optionalButton.getSelection();
        this.resultOperation = new PomEdits.Operation(){

            @Override
            public void process(Document document) {
                Element depsEl = EditDependencyDialog.this.dependencyManagement ? PomEdits.getChild(document.getDocumentElement(), "dependencyManagement", "dependencies") : PomEdits.getChild(document.getDocumentElement(), "dependencies");
                Element dep = PomEdits.findChild(depsEl, "dependency", PomEdits.childEquals("groupId", oldGroupId), PomEdits.childEquals("artifactId", oldArtifactId));
                if (dep != null) {
                    if (artifactId != null && !artifactId.equals(oldArtifactId)) {
                        PomEdits.setText(PomEdits.getChild(dep, "artifactId"), artifactId);
                    }
                    if (groupId != null && !groupId.equals(oldGroupId)) {
                        PomEdits.setText(PomEdits.getChild(dep, "groupId"), groupId);
                    }
                    if (version != null) {
                        PomEdits.setText(PomEdits.getChild(dep, "version"), version);
                    } else {
                        PomEdits.removeChild(dep, PomEdits.findChild(dep, "version"));
                    }
                    if (type != null && !"jar".equals(type) && !"null".equals(type)) {
                        PomEdits.setText(PomEdits.getChild(dep, "type"), type);
                    } else {
                        PomEdits.removeChild(dep, PomEdits.findChild(dep, "type"));
                    }
                    if (classifier != null) {
                        PomEdits.setText(PomEdits.getChild(dep, "classifier"), classifier);
                    } else {
                        PomEdits.removeChild(dep, PomEdits.findChild(dep, "classifier"));
                    }
                    if (scope != null && !"compile".equals(scope)) {
                        PomEdits.setText(PomEdits.getChild(dep, "scope"), scope);
                    } else {
                        PomEdits.removeChild(dep, PomEdits.findChild(dep, "scope"));
                    }
                    if (system != null) {
                        PomEdits.setText(PomEdits.getChild(dep, "systemPath"), system);
                    } else {
                        PomEdits.removeChild(dep, PomEdits.findChild(dep, "systemPath"));
                    }
                    if (optional) {
                        PomEdits.setText(PomEdits.getChild(dep, "optional"), Boolean.toString(optional));
                    } else {
                        PomEdits.removeChild(dep, PomEdits.findChild(dep, "optional"));
                    }
                }
            }
        };
    }

    private String valueOrNull(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
        if (dependency != null && this.groupIdText != null && !this.groupIdText.isDisposed()) {
            this.groupIdText.setText(Util.nvl(dependency.getGroupId()));
            this.artifactIdText.setText(Util.nvl(dependency.getArtifactId()));
            this.versionText.setText(Util.nvl(dependency.getVersion()));
            this.classifierText.setText(Util.nvl(dependency.getClassifier()));
            this.typeCombo.setText("".equals(Util.nvl(dependency.getType())) ? "jar" : dependency.getType());
            this.scopeCombo.setText("".equals(Util.nvl(dependency.getScope())) ? "compile" : dependency.getScope());
            this.systemPathText.setText(Util.nvl(dependency.getSystemPath()));
            boolean optional = Boolean.parseBoolean(dependency.getOptional());
            if (this.optionalButton.getSelection() != optional) {
                this.optionalButton.setSelection(optional);
            }
        }
    }
}

